/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.skodjob.testframe.interfaces.ResourceType;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceCondition<T extends HasMetadata> {
    private final Predicate<T> predicate;
    private final String conditionName;

    public ResourceCondition(Predicate<T> predicate, String conditionName) {
        this.predicate = predicate;
        this.conditionName = conditionName;
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public static <T extends HasMetadata> ResourceCondition<T> readiness(ResourceType<T> type) {
        return new ResourceCondition<HasMetadata>(type::waitForReadiness, "readiness");
    }

    public static <T extends HasMetadata> ResourceCondition<T> deletion() {
        return new ResourceCondition<HasMetadata>(Objects::isNull, "deletion");
    }
}

