/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionalProxy;
import org.springframework.util.ObjectUtils;

abstract class TransactionAttributeSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    TransactionAttributeSourcePointcut() {
    }

    @Override
    public boolean matches(Method method, @Nullable Class<?> targetClass) {
        if (targetClass != null && TransactionalProxy.class.isAssignableFrom(targetClass)) {
            return false;
        }
        TransactionAttributeSource tas = this.getTransactionAttributeSource();
        return tas == null || tas.getTransactionAttribute(method, targetClass) != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransactionAttributeSourcePointcut)) {
            return false;
        }
        TransactionAttributeSourcePointcut otherPc = (TransactionAttributeSourcePointcut)other;
        return ObjectUtils.nullSafeEquals(this.getTransactionAttributeSource(), otherPc.getTransactionAttributeSource());
    }

    public int hashCode() {
        return TransactionAttributeSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getTransactionAttributeSource();
    }

    @Nullable
    protected abstract TransactionAttributeSource getTransactionAttributeSource();
}

