/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.web.reactive.server.DefaultWebTestClientBuilder;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.HeaderAssertions;
import org.springframework.test.web.reactive.server.JsonPathAssertions;
import org.springframework.test.web.reactive.server.StatusAssertions;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.test.web.reactive.server.WiretapConnector;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Flux;

class DefaultWebTestClient
implements WebTestClient {
    private final WebClient webClient;
    private final WiretapConnector wiretapConnector;
    private final Duration timeout;
    private final DefaultWebTestClientBuilder builder;
    private final AtomicLong requestIndex = new AtomicLong();

    DefaultWebTestClient(WebClient.Builder clientBuilder, ClientHttpConnector connector, @Nullable Duration timeout, DefaultWebTestClientBuilder webTestClientBuilder) {
        Assert.notNull((Object)clientBuilder, "WebClient.Builder is required");
        this.wiretapConnector = new WiretapConnector(connector);
        this.webClient = clientBuilder.clientConnector((ClientHttpConnector)this.wiretapConnector).build();
        this.timeout = timeout != null ? timeout : Duration.ofSeconds(5L);
        this.builder = webTestClientBuilder;
    }

    private Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec method(HttpMethod method) {
        return this.methodInternal(method);
    }

    private WebTestClient.RequestBodyUriSpec methodInternal(HttpMethod method) {
        return new DefaultRequestBodyUriSpec(this.webClient.method(method));
    }

    @Override
    public WebTestClient.Builder mutate() {
        return new DefaultWebTestClientBuilder(this.builder);
    }

    @Override
    public WebTestClient mutateWith(WebTestClientConfigurer configurer) {
        return this.mutate().apply(configurer).build();
    }

    private static class DefaultBodyContentSpec
    implements WebTestClient.BodyContentSpec {
        private final EntityExchangeResult<byte[]> result;
        private final boolean isEmpty;

        DefaultBodyContentSpec(EntityExchangeResult<byte[]> result) {
            this.result = result;
            this.isEmpty = result.getResponseBody() == null;
        }

        @Override
        public EntityExchangeResult<Void> isEmpty() {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue("Expected empty body", this.isEmpty));
            return new EntityExchangeResult<Object>(this.result, null);
        }

        @Override
        public WebTestClient.BodyContentSpec json(String json) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    new JsonExpectationsHelper().assertJsonEqual(json, this.getBodyAsString());
                }
                catch (Exception ex) {
                    throw new AssertionError("JSON parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public JsonPathAssertions jsonPath(String expression, Object ... args) {
            return new JsonPathAssertions(this, this.getBodyAsString(), expression, args);
        }

        private String getBodyAsString() {
            byte[] body = this.result.getResponseBody();
            if (body == null || body.length == 0) {
                return "";
            }
            MediaType mediaType = this.result.getResponseHeaders().getContentType();
            Charset charset = Optional.ofNullable(mediaType).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
            return new String(body, charset);
        }

        @Override
        public WebTestClient.BodyContentSpec consumeWith(Consumer<EntityExchangeResult<byte[]>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this;
        }

        @Override
        public EntityExchangeResult<byte[]> returnResult() {
            return this.result;
        }
    }

    private static class DefaultListBodySpec<E>
    extends DefaultBodySpec<List<E>, WebTestClient.ListBodySpec<E>>
    implements WebTestClient.ListBodySpec<E> {
        DefaultListBodySpec(EntityExchangeResult<List<E>> result) {
            super(result);
        }

        @Override
        public WebTestClient.ListBodySpec<E> hasSize(int size) {
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body does not contain " + size + " elements";
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, size, actual != null ? actual.size() : 0));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec<E> contains(E ... elements) {
            List expected = Arrays.asList(elements);
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body does not contain " + expected;
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual != null && actual.containsAll(expected)));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec<E> doesNotContain(E ... elements) {
            List expected = Arrays.asList(elements);
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body should not have contained " + expected;
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual == null || !actual.containsAll(expected)));
            return this;
        }

        @Override
        public EntityExchangeResult<List<E>> returnResult() {
            return this.getResult();
        }
    }

    private static class DefaultBodySpec<B, S extends WebTestClient.BodySpec<B, S>>
    implements WebTestClient.BodySpec<B, S> {
        private final EntityExchangeResult<B> result;

        DefaultBodySpec(EntityExchangeResult<B> result) {
            this.result = result;
        }

        protected EntityExchangeResult<B> getResult() {
            return this.result;
        }

        @Override
        public <T extends S> T isEqualTo(B expected) {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response body", expected, this.result.getResponseBody()));
            return this.self();
        }

        @Override
        public <T extends S> T consumeWith(Consumer<EntityExchangeResult<B>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this.self();
        }

        private <T extends S> T self() {
            return (T)this;
        }

        @Override
        public EntityExchangeResult<B> returnResult() {
            return this.result;
        }
    }

    private static class DefaultResponseSpec
    implements WebTestClient.ResponseSpec {
        private final ExchangeResult exchangeResult;
        private final ClientResponse response;
        private final Duration timeout;

        DefaultResponseSpec(WiretapConnector.Info wiretapInfo, ClientResponse response, @Nullable String uriTemplate, Duration timeout) {
            this.exchangeResult = wiretapInfo.createExchangeResult(uriTemplate);
            this.response = response;
            this.timeout = timeout;
        }

        @Override
        public StatusAssertions expectStatus() {
            return new StatusAssertions(this.exchangeResult, this);
        }

        @Override
        public HeaderAssertions expectHeader() {
            return new HeaderAssertions(this.exchangeResult, this);
        }

        @Override
        public <B> WebTestClient.BodySpec<B, ?> expectBody(Class<B> bodyType) {
            Object body = this.response.bodyToMono(bodyType).block(this.timeout);
            EntityExchangeResult<Object> entityResult = new EntityExchangeResult<Object>(this.exchangeResult, body);
            return new DefaultBodySpec(entityResult);
        }

        @Override
        public <B> WebTestClient.BodySpec<B, ?> expectBody(ParameterizedTypeReference<B> bodyType) {
            Object body = this.response.bodyToMono(bodyType).block(this.timeout);
            EntityExchangeResult<Object> entityResult = new EntityExchangeResult<Object>(this.exchangeResult, body);
            return new DefaultBodySpec(entityResult);
        }

        @Override
        public <E> WebTestClient.ListBodySpec<E> expectBodyList(Class<E> elementType) {
            return this.getListBodySpec(this.response.bodyToFlux(elementType));
        }

        @Override
        public <E> WebTestClient.ListBodySpec<E> expectBodyList(ParameterizedTypeReference<E> elementType) {
            Flux flux = this.response.bodyToFlux(elementType);
            return this.getListBodySpec(flux);
        }

        private <E> WebTestClient.ListBodySpec<E> getListBodySpec(Flux<E> flux) {
            List body = (List)flux.collectList().block(this.timeout);
            EntityExchangeResult entityResult = new EntityExchangeResult(this.exchangeResult, body);
            return new DefaultListBodySpec(entityResult);
        }

        @Override
        public WebTestClient.BodyContentSpec expectBody() {
            ByteArrayResource resource = (ByteArrayResource)this.response.bodyToMono(ByteArrayResource.class).block(this.timeout);
            byte[] body = resource != null ? resource.getByteArray() : null;
            EntityExchangeResult<byte[]> entityResult = new EntityExchangeResult<byte[]>(this.exchangeResult, body);
            return new DefaultBodyContentSpec(entityResult);
        }

        @Override
        public <T> FluxExchangeResult<T> returnResult(Class<T> elementType) {
            Flux body = this.response.bodyToFlux(elementType);
            return new FluxExchangeResult(this.exchangeResult, body, this.timeout);
        }

        @Override
        public <T> FluxExchangeResult<T> returnResult(ParameterizedTypeReference<T> elementType) {
            Flux body = this.response.bodyToFlux(elementType);
            return new FluxExchangeResult(this.exchangeResult, body, this.timeout);
        }
    }

    private class DefaultRequestBodyUriSpec
    implements WebTestClient.RequestBodyUriSpec {
        private final WebClient.RequestBodyUriSpec bodySpec;
        @Nullable
        private String uriTemplate;
        private final String requestId;

        DefaultRequestBodyUriSpec(WebClient.RequestBodyUriSpec spec) {
            this.bodySpec = spec;
            this.requestId = String.valueOf(DefaultWebTestClient.this.requestIndex.incrementAndGet());
            this.bodySpec.header("WebTestClient-Request-Id", new String[]{this.requestId});
        }

        @Override
        public WebTestClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            this.bodySpec.uri(uriTemplate, uriVariables);
            this.uriTemplate = uriTemplate;
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            this.bodySpec.uri(uriTemplate, uriVariables);
            this.uriTemplate = uriTemplate;
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            this.bodySpec.uri(uriFunction);
            this.uriTemplate = null;
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec uri(URI uri) {
            this.bodySpec.uri(uri);
            this.uriTemplate = null;
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec header(String headerName, String ... headerValues) {
            this.bodySpec.header(headerName, headerValues);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec headers(Consumer<HttpHeaders> headersConsumer) {
            this.bodySpec.headers(headersConsumer);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec attribute(String name, Object value) {
            this.bodySpec.attribute(name, value);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            this.bodySpec.attributes(attributesConsumer);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec accept(MediaType ... acceptableMediaTypes) {
            this.bodySpec.accept(acceptableMediaTypes);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec acceptCharset(Charset ... acceptableCharsets) {
            this.bodySpec.acceptCharset(acceptableCharsets);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec contentType(MediaType contentType) {
            this.bodySpec.contentType(contentType);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec contentLength(long contentLength) {
            this.bodySpec.contentLength(contentLength);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec cookie(String name, String value) {
            this.bodySpec.cookie(name, value);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            this.bodySpec.cookies(cookiesConsumer);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.bodySpec.ifModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec ifNoneMatch(String ... ifNoneMatches) {
            this.bodySpec.ifNoneMatch(ifNoneMatches);
            return this;
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.bodySpec.body(inserter);
            return this;
        }

        @Override
        public <T, S extends Publisher<T>> WebTestClient.RequestHeadersSpec<?> body(S publisher, Class<T> elementClass) {
            this.bodySpec.body(publisher, elementClass);
            return this;
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> syncBody(Object body) {
            this.bodySpec.syncBody(body);
            return this;
        }

        @Override
        public WebTestClient.ResponseSpec exchange() {
            ClientResponse clientResponse = (ClientResponse)this.bodySpec.exchange().block(DefaultWebTestClient.this.getTimeout());
            Assert.state(clientResponse != null, "No ClientResponse");
            WiretapConnector.Info info = DefaultWebTestClient.this.wiretapConnector.claimRequest(this.requestId);
            return new DefaultResponseSpec(info, clientResponse, this.uriTemplate, DefaultWebTestClient.this.getTimeout());
        }
    }
}

