/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractContextLoader
implements SmartContextLoader {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Log logger = LogFactory.getLog(AbstractContextLoader.class);

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        String[] processedLocations = this.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
        configAttributes.setLocations(processedLocations);
    }

    protected void prepareContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        context.getEnvironment().setActiveProfiles(mergedConfig.getActiveProfiles());
        TestPropertySourceUtils.addPropertiesFilesToEnvironment(context, mergedConfig.getPropertySourceLocations());
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment(context, mergedConfig.getPropertySourceProperties());
        this.invokeApplicationContextInitializers(context, mergedConfig);
    }

    private void invokeApplicationContextInitializers(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        Set<Class<ApplicationContextInitializer<?>>> initializerClasses = mergedConfig.getContextInitializerClasses();
        if (initializerClasses.isEmpty()) {
            return;
        }
        ArrayList initializerInstances = new ArrayList();
        Class<?> contextClass = context.getClass();
        for (Class<ApplicationContextInitializer<?>> clazz : initializerClasses) {
            Class<?> initializerContextClass = GenericTypeResolver.resolveTypeArgument(clazz, ApplicationContextInitializer.class);
            if (initializerContextClass != null && !initializerContextClass.isInstance(context)) {
                throw new ApplicationContextException(String.format("Could not apply context initializer [%s] since its generic parameter [%s] is not assignable from the type of application context used by this context loader: [%s]", clazz.getName(), initializerContextClass.getName(), contextClass.getName()));
            }
            initializerInstances.add(BeanUtils.instantiateClass(clazz));
        }
        AnnotationAwareOrderComparator.sort(initializerInstances);
        for (ApplicationContextInitializer applicationContextInitializer : initializerInstances) {
            applicationContextInitializer.initialize(context);
        }
    }

    protected void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        for (ContextCustomizer contextCustomizer : mergedConfig.getContextCustomizers()) {
            contextCustomizer.customizeContext(context, mergedConfig);
        }
    }

    @Override
    public final String[] processLocations(Class<?> clazz, String ... locations) {
        return ObjectUtils.isEmpty(locations) && this.isGenerateDefaultLocations() ? this.generateDefaultLocations(clazz) : this.modifyLocations(clazz, locations);
    }

    protected String[] generateDefaultLocations(Class<?> clazz) {
        Object[] suffixes;
        Assert.notNull(clazz, "Class must not be null");
        for (String string : suffixes = this.getResourceSuffixes()) {
            Assert.hasText(string, "Resource suffix must not be empty");
            String resourcePath = ClassUtils.convertClassNameToResourcePath(clazz.getName()) + string;
            String prefixedResourcePath = "classpath:" + resourcePath;
            ClassPathResource classPathResource = new ClassPathResource(resourcePath);
            if (classPathResource.exists()) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Detected default resource location \"%s\" for test class [%s]", prefixedResourcePath, clazz.getName()));
                }
                return new String[]{prefixedResourcePath};
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(String.format("Did not detect default resource location for test class [%s]: %s does not exist", clazz.getName(), classPathResource));
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Could not detect default resource locations for test class [%s]: no resource found for suffixes %s.", clazz.getName(), ObjectUtils.nullSafeToString(suffixes)));
        }
        return EMPTY_STRING_ARRAY;
    }

    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        return TestContextResourceUtils.convertToClasspathResourcePaths(clazz, locations);
    }

    protected boolean isGenerateDefaultLocations() {
        return true;
    }

    protected String[] getResourceSuffixes() {
        return new String[]{this.getResourceSuffix()};
    }

    protected abstract String getResourceSuffix();
}

