/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Constants;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.lang.Nullable;

public class LazyConnectionDataSourceProxy
extends DelegatingDataSource {
    private static final Constants constants = new Constants(Connection.class);
    private static final Log logger = LogFactory.getLog(LazyConnectionDataSourceProxy.class);
    @Nullable
    private Boolean defaultAutoCommit;
    @Nullable
    private Integer defaultTransactionIsolation;

    public LazyConnectionDataSourceProxy() {
    }

    public LazyConnectionDataSourceProxy(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
        this.afterPropertiesSet();
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolationName(String constantName) {
        this.setDefaultTransactionIsolation(constants.asNumber(constantName).intValue());
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.defaultAutoCommit == null || this.defaultTransactionIsolation == null) {
            try (Connection con = this.obtainTargetDataSource().getConnection();){
                this.checkDefaultConnectionProperties(con);
            }
            catch (SQLException ex) {
                logger.warn("Could not retrieve default auto-commit and transaction isolation settings", ex);
            }
        }
    }

    protected synchronized void checkDefaultConnectionProperties(Connection con) throws SQLException {
        if (this.defaultAutoCommit == null) {
            this.defaultAutoCommit = con.getAutoCommit();
        }
        if (this.defaultTransactionIsolation == null) {
            this.defaultTransactionIsolation = con.getTransactionIsolation();
        }
    }

    @Nullable
    protected Boolean defaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    @Nullable
    protected Integer defaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new LazyConnectionInvocationHandler());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new LazyConnectionInvocationHandler(username, password));
    }

    private class LazyConnectionInvocationHandler
    implements InvocationHandler {
        @Nullable
        private String username;
        @Nullable
        private String password;
        private Boolean readOnly = Boolean.FALSE;
        @Nullable
        private Boolean autoCommit;
        @Nullable
        private Integer transactionIsolation;
        private boolean closed = false;
        @Nullable
        private Connection target;

        public LazyConnectionInvocationHandler() {
            this.autoCommit = LazyConnectionDataSourceProxy.this.defaultAutoCommit();
            this.transactionIsolation = LazyConnectionDataSourceProxy.this.defaultTransactionIsolation();
        }

        public LazyConnectionInvocationHandler(String username, String password) {
            this();
            this.username = username;
            this.password = password;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("unwrap")) {
                if (((Class)args[0]).isInstance(proxy)) {
                    return proxy;
                }
            } else if (method.getName().equals("isWrapperFor")) {
                if (((Class)args[0]).isInstance(proxy)) {
                    return true;
                }
            } else if (method.getName().equals("getTargetConnection")) {
                return this.getTargetConnection(method);
            }
            if (!this.hasTargetConnection()) {
                if (method.getName().equals("toString")) {
                    return "Lazy Connection proxy for target DataSource [" + LazyConnectionDataSourceProxy.this.getTargetDataSource() + "]";
                }
                if (method.getName().equals("isReadOnly")) {
                    return this.readOnly;
                }
                if (method.getName().equals("setReadOnly")) {
                    this.readOnly = (Boolean)args[0];
                    return null;
                }
                if (method.getName().equals("getTransactionIsolation")) {
                    if (this.transactionIsolation != null) {
                        return this.transactionIsolation;
                    }
                } else {
                    if (method.getName().equals("setTransactionIsolation")) {
                        this.transactionIsolation = (Integer)args[0];
                        return null;
                    }
                    if (method.getName().equals("getAutoCommit")) {
                        if (this.autoCommit != null) {
                            return this.autoCommit;
                        }
                    } else {
                        if (method.getName().equals("setAutoCommit")) {
                            this.autoCommit = (Boolean)args[0];
                            return null;
                        }
                        if (method.getName().equals("commit")) {
                            return null;
                        }
                        if (method.getName().equals("rollback")) {
                            return null;
                        }
                        if (method.getName().equals("getWarnings")) {
                            return null;
                        }
                        if (method.getName().equals("clearWarnings")) {
                            return null;
                        }
                        if (method.getName().equals("close")) {
                            this.closed = true;
                            return null;
                        }
                        if (method.getName().equals("isClosed")) {
                            return this.closed;
                        }
                        if (this.closed) {
                            throw new SQLException("Illegal operation: connection is closed");
                        }
                    }
                }
            }
            try {
                return method.invoke((Object)this.getTargetConnection(method), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private boolean hasTargetConnection() {
            return this.target != null;
        }

        private Connection getTargetConnection(Method operation) throws SQLException {
            if (this.target == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Connecting to database for operation '" + operation.getName() + "'");
                }
                this.target = this.username != null ? LazyConnectionDataSourceProxy.this.obtainTargetDataSource().getConnection(this.username, this.password) : LazyConnectionDataSourceProxy.this.obtainTargetDataSource().getConnection();
                LazyConnectionDataSourceProxy.this.checkDefaultConnectionProperties(this.target);
                if (this.readOnly.booleanValue()) {
                    try {
                        this.target.setReadOnly(true);
                    }
                    catch (Exception ex) {
                        logger.debug("Could not set JDBC Connection read-only", ex);
                    }
                }
                if (this.transactionIsolation != null && !this.transactionIsolation.equals(LazyConnectionDataSourceProxy.this.defaultTransactionIsolation())) {
                    this.target.setTransactionIsolation(this.transactionIsolation);
                }
                if (this.autoCommit != null && this.autoCommit.booleanValue() != this.target.getAutoCommit()) {
                    this.target.setAutoCommit(this.autoCommit);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Using existing database connection for operation '" + operation.getName() + "'");
            }
            return this.target;
        }
    }
}

