/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.template;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.mapstruct.ap.shaded.freemarker.cache.CacheStorage;
import org.mapstruct.ap.shaded.freemarker.cache.ClassTemplateLoader;
import org.mapstruct.ap.shaded.freemarker.cache.FileTemplateLoader;
import org.mapstruct.ap.shaded.freemarker.cache.MruCacheStorage;
import org.mapstruct.ap.shaded.freemarker.cache.TemplateCache;
import org.mapstruct.ap.shaded.freemarker.cache.TemplateLoader;
import org.mapstruct.ap.shaded.freemarker.cache._CacheAPI;
import org.mapstruct.ap.shaded.freemarker.core.BugException;
import org.mapstruct.ap.shaded.freemarker.core.Configurable;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core._ConcurrentMapFactory;
import org.mapstruct.ap.shaded.freemarker.core._CoreAPI;
import org.mapstruct.ap.shaded.freemarker.core._ObjectBuilderSettingEvaluator;
import org.mapstruct.ap.shaded.freemarker.core._SettingEvaluationEnvironment;
import org.mapstruct.ap.shaded.freemarker.template.DefaultObjectWrapperBuilder;
import org.mapstruct.ap.shaded.freemarker.template.ObjectWrapper;
import org.mapstruct.ap.shaded.freemarker.template.Template;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateHashModelEx;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelIterator;
import org.mapstruct.ap.shaded.freemarker.template.TemplateScalarModel;
import org.mapstruct.ap.shaded.freemarker.template.Version;
import org.mapstruct.ap.shaded.freemarker.template._TemplateAPI;
import org.mapstruct.ap.shaded.freemarker.template.utility.CaptureOutput;
import org.mapstruct.ap.shaded.freemarker.template.utility.ClassUtil;
import org.mapstruct.ap.shaded.freemarker.template.utility.HtmlEscape;
import org.mapstruct.ap.shaded.freemarker.template.utility.NormalizeNewlines;
import org.mapstruct.ap.shaded.freemarker.template.utility.NullArgumentException;
import org.mapstruct.ap.shaded.freemarker.template.utility.SecurityUtilities;
import org.mapstruct.ap.shaded.freemarker.template.utility.StandardCompress;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;
import org.mapstruct.ap.shaded.freemarker.template.utility.XmlEscape;

public class Configuration
extends Configurable
implements Cloneable {
    private static final String VERSION_PROPERTIES_PATH = "org/mapstruct/ap/shaded/freemarker/version.properties";
    public static final String DEFAULT_ENCODING_KEY = "default_encoding";
    public static final String LOCALIZED_LOOKUP_KEY = "localized_lookup";
    public static final String STRICT_SYNTAX_KEY = "strict_syntax";
    public static final String WHITESPACE_STRIPPING_KEY = "whitespace_stripping";
    public static final String CACHE_STORAGE_KEY = "cache_storage";
    public static final String TEMPLATE_UPDATE_DELAY_KEY = "template_update_delay";
    public static final String AUTO_IMPORT_KEY = "auto_import";
    public static final String AUTO_INCLUDE_KEY = "auto_include";
    public static final String TAG_SYNTAX_KEY = "tag_syntax";
    public static final String TEMPLATE_LOADER_KEY = "template_loader";
    public static final String INCOMPATIBLE_IMPROVEMENTS = "incompatible_improvements";
    public static final String INCOMPATIBLE_ENHANCEMENTS = "incompatible_enhancements";
    public static final int AUTO_DETECT_TAG_SYNTAX = 0;
    public static final int ANGLE_BRACKET_TAG_SYNTAX = 1;
    public static final int SQUARE_BRACKET_TAG_SYNTAX = 2;
    public static final Version VERSION_2_3_0 = new Version(2, 3, 0);
    public static final Version VERSION_2_3_19 = new Version(2, 3, 19);
    public static final Version VERSION_2_3_20 = new Version(2, 3, 20);
    public static final Version VERSION_2_3_21 = new Version(2, 3, 21);
    public static final Version DEFAULT_INCOMPATIBLE_IMPROVEMENTS = VERSION_2_3_0;
    public static final String DEFAULT_INCOMPATIBLE_ENHANCEMENTS = DEFAULT_INCOMPATIBLE_IMPROVEMENTS.toString();
    public static final int PARSED_DEFAULT_INCOMPATIBLE_ENHANCEMENTS = DEFAULT_INCOMPATIBLE_IMPROVEMENTS.intValue();
    private static final Version version;
    private static final Object defaultConfigLock;
    private static Configuration defaultConfig;
    private boolean strictSyntax = true;
    private volatile boolean localizedLookup = true;
    private boolean whitespaceStripping = true;
    private Version incompatibleImprovements;
    private int tagSyntax = 1;
    private TemplateCache cache;
    private boolean templateLoaderWasSet;
    private boolean objectWrapperWasSet;
    private HashMap sharedVariables = new HashMap();
    private HashMap rewrappableSharedVariables = null;
    private String defaultEncoding = SecurityUtilities.getSystemProperty("file.encoding");
    private Map localeToCharsetMap = _ConcurrentMapFactory.newThreadSafeMap();
    private ArrayList autoImports = new ArrayList();
    private ArrayList autoIncludes = new ArrayList();
    private Map autoImportNsToTmpMap = new HashMap();

    public Configuration() {
        this(DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    }

    public Configuration(Version incompatibleImprovements) {
        super(incompatibleImprovements);
        NullArgumentException.check("incompatibleImprovements", incompatibleImprovements);
        this.incompatibleImprovements = incompatibleImprovements;
        this.createTemplateCache();
        this.loadBuiltInSharedVariables();
    }

    private void createTemplateCache() {
        this.cache = new TemplateCache(this.getDefaultTemplateLoader(), this);
        this.cache.clear();
        this.cache.setDelay(5000L);
    }

    private void recreateTemplateCacheWith(TemplateLoader loader, CacheStorage storage) {
        TemplateCache oldCache = this.cache;
        this.cache = new TemplateCache(loader, storage, this);
        this.cache.clear();
        this.cache.setDelay(oldCache.getDelay());
        this.cache.setLocalizedLookup(this.localizedLookup);
    }

    private TemplateLoader getDefaultTemplateLoader() {
        return this.incompatibleImprovements.intValue() < _TemplateAPI.VERSION_INT_2_3_21 ? _CacheAPI.createLegacyDefaultTemplateLoader() : null;
    }

    public Object clone() {
        try {
            Configuration copy = (Configuration)super.clone();
            copy.sharedVariables = new HashMap(this.sharedVariables);
            copy.localeToCharsetMap = new HashMap(this.localeToCharsetMap);
            copy.autoImportNsToTmpMap = new HashMap(this.autoImportNsToTmpMap);
            copy.autoImports = (ArrayList)this.autoImports.clone();
            copy.autoIncludes = (ArrayList)this.autoIncludes.clone();
            copy.recreateTemplateCacheWith(this.cache.getTemplateLoader(), this.cache.getCacheStorage());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new BugException(e.getMessage());
        }
    }

    private void loadBuiltInSharedVariables() {
        this.sharedVariables.put("capture_output", new CaptureOutput());
        this.sharedVariables.put("compress", StandardCompress.INSTANCE);
        this.sharedVariables.put("html_escape", new HtmlEscape());
        this.sharedVariables.put("normalize_newlines", new NormalizeNewlines());
        this.sharedVariables.put("xml_escape", new XmlEscape());
    }

    public void loadBuiltInEncodingMap() {
        this.localeToCharsetMap.clear();
        this.localeToCharsetMap.put("ar", "ISO-8859-6");
        this.localeToCharsetMap.put("be", "ISO-8859-5");
        this.localeToCharsetMap.put("bg", "ISO-8859-5");
        this.localeToCharsetMap.put("ca", "ISO-8859-1");
        this.localeToCharsetMap.put("cs", "ISO-8859-2");
        this.localeToCharsetMap.put("da", "ISO-8859-1");
        this.localeToCharsetMap.put("de", "ISO-8859-1");
        this.localeToCharsetMap.put("el", "ISO-8859-7");
        this.localeToCharsetMap.put("en", "ISO-8859-1");
        this.localeToCharsetMap.put("es", "ISO-8859-1");
        this.localeToCharsetMap.put("et", "ISO-8859-1");
        this.localeToCharsetMap.put("fi", "ISO-8859-1");
        this.localeToCharsetMap.put("fr", "ISO-8859-1");
        this.localeToCharsetMap.put("hr", "ISO-8859-2");
        this.localeToCharsetMap.put("hu", "ISO-8859-2");
        this.localeToCharsetMap.put("is", "ISO-8859-1");
        this.localeToCharsetMap.put("it", "ISO-8859-1");
        this.localeToCharsetMap.put("iw", "ISO-8859-8");
        this.localeToCharsetMap.put("ja", "Shift_JIS");
        this.localeToCharsetMap.put("ko", "EUC-KR");
        this.localeToCharsetMap.put("lt", "ISO-8859-2");
        this.localeToCharsetMap.put("lv", "ISO-8859-2");
        this.localeToCharsetMap.put("mk", "ISO-8859-5");
        this.localeToCharsetMap.put("nl", "ISO-8859-1");
        this.localeToCharsetMap.put("no", "ISO-8859-1");
        this.localeToCharsetMap.put("pl", "ISO-8859-2");
        this.localeToCharsetMap.put("pt", "ISO-8859-1");
        this.localeToCharsetMap.put("ro", "ISO-8859-2");
        this.localeToCharsetMap.put("ru", "ISO-8859-5");
        this.localeToCharsetMap.put("sh", "ISO-8859-5");
        this.localeToCharsetMap.put("sk", "ISO-8859-2");
        this.localeToCharsetMap.put("sl", "ISO-8859-2");
        this.localeToCharsetMap.put("sq", "ISO-8859-2");
        this.localeToCharsetMap.put("sr", "ISO-8859-5");
        this.localeToCharsetMap.put("sv", "ISO-8859-1");
        this.localeToCharsetMap.put("tr", "ISO-8859-9");
        this.localeToCharsetMap.put("uk", "ISO-8859-5");
        this.localeToCharsetMap.put("zh", "GB2312");
        this.localeToCharsetMap.put("zh_TW", "Big5");
    }

    public void clearEncodingMap() {
        this.localeToCharsetMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getDefaultConfiguration() {
        Object object = defaultConfigLock;
        synchronized (object) {
            if (defaultConfig == null) {
                defaultConfig = new Configuration();
            }
            return defaultConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConfiguration(Configuration config) {
        Object object = defaultConfigLock;
        synchronized (object) {
            defaultConfig = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplateLoader(TemplateLoader templateLoader) {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.cache.getTemplateLoader() != templateLoader) {
                this.recreateTemplateCacheWith(templateLoader, this.cache.getCacheStorage());
                this.templateLoaderWasSet = true;
            }
        }
    }

    public TemplateLoader getTemplateLoader() {
        return this.cache.getTemplateLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheStorage(CacheStorage storage) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.recreateTemplateCacheWith(this.cache.getTemplateLoader(), storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStorage getCacheStorage() {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.cache.getCacheStorage();
        }
    }

    public void setDirectoryForTemplateLoading(File dir) throws IOException {
        String path;
        TemplateLoader tl = this.getTemplateLoader();
        if (tl instanceof FileTemplateLoader && (path = ((FileTemplateLoader)tl).baseDir.getCanonicalPath()).equals(dir.getCanonicalPath())) {
            return;
        }
        this.setTemplateLoader(new FileTemplateLoader(dir));
    }

    public void setServletContextForTemplateLoading(Object servletContext, String path) {
        try {
            Object[] constructorParams;
            Class[] constructorParamTypes;
            Class webappTemplateLoaderClass = ClassUtil.forName("org.mapstruct.ap.shaded.freemarker.cache.WebappTemplateLoader");
            Class servletContextClass = ClassUtil.forName("javax.servlet.ServletContext");
            if (path == null) {
                constructorParamTypes = new Class[]{servletContextClass};
                constructorParams = new Object[]{servletContext};
            } else {
                constructorParamTypes = new Class[]{servletContextClass, String.class};
                constructorParams = new Object[]{servletContext, path};
            }
            this.setTemplateLoader((TemplateLoader)webappTemplateLoaderClass.getConstructor(constructorParamTypes).newInstance(constructorParams));
        }
        catch (Exception e) {
            throw new BugException(e);
        }
    }

    public void setClassForTemplateLoading(Class clazz, String pathPrefix) {
        this.setTemplateLoader(new ClassTemplateLoader(clazz, pathPrefix));
    }

    public void setTemplateUpdateDelay(int seconds) {
        this.cache.setDelay(1000L * (long)seconds);
    }

    public void setStrictSyntaxMode(boolean b) {
        this.strictSyntax = b;
    }

    public void setObjectWrapper(ObjectWrapper objectWrapper) {
        ObjectWrapper prevObjectWrapper = this.getObjectWrapper();
        super.setObjectWrapper(objectWrapper);
        this.objectWrapperWasSet = true;
        if (objectWrapper != prevObjectWrapper) {
            try {
                this.setSharedVariablesFromRewrappableSharedVariables();
            }
            catch (TemplateModelException e) {
                throw new RuntimeException("Failed to re-wrap earliearly set shared variables with the newly set object wrapper", e);
            }
        }
    }

    public boolean getStrictSyntaxMode() {
        return this.strictSyntax;
    }

    public void setIncompatibleImprovements(Version incompatibleImprovements) {
        _TemplateAPI.checkVersionNotNullAndSupported(incompatibleImprovements);
        boolean hadLegacyTLOWDefaults = this.incompatibleImprovements.intValue() < _TemplateAPI.VERSION_INT_2_3_21;
        this.incompatibleImprovements = incompatibleImprovements;
        if (hadLegacyTLOWDefaults != incompatibleImprovements.intValue() < _TemplateAPI.VERSION_INT_2_3_21) {
            if (!this.templateLoaderWasSet) {
                this.recreateTemplateCacheWith(this.getDefaultTemplateLoader(), this.cache.getCacheStorage());
            }
            if (!this.objectWrapperWasSet) {
                super.setObjectWrapper(Configuration.getDefaultObjectWrapper(incompatibleImprovements));
            }
        }
    }

    public Version getIncompatibleImprovements() {
        return this.incompatibleImprovements;
    }

    public void setIncompatibleEnhancements(String version) {
        this.setIncompatibleImprovements(new Version(version));
    }

    public String getIncompatibleEnhancements() {
        return this.incompatibleImprovements.toString();
    }

    public int getParsedIncompatibleEnhancements() {
        return this.getIncompatibleImprovements().intValue();
    }

    public void setWhitespaceStripping(boolean b) {
        this.whitespaceStripping = b;
    }

    public boolean getWhitespaceStripping() {
        return this.whitespaceStripping;
    }

    public void setTagSyntax(int tagSyntax) {
        if (tagSyntax != 0 && tagSyntax != 2 && tagSyntax != 1) {
            throw new IllegalArgumentException("\"tag_syntax\" can only be set to one of these: Configuration.AUTO_DETECT_TAG_SYNTAX, Configuration.ANGLE_BRACKET_SYNTAX, or Configuration.SQAUARE_BRACKET_SYNTAX");
        }
        this.tagSyntax = tagSyntax;
    }

    public int getTagSyntax() {
        return this.tagSyntax;
    }

    public Template getTemplate(String name) throws IOException {
        Locale loc = this.getLocale();
        return this.getTemplate(name, loc, this.getEncoding(loc), true);
    }

    public Template getTemplate(String name, Locale locale) throws IOException {
        return this.getTemplate(name, locale, this.getEncoding(locale), true);
    }

    public Template getTemplate(String name, String encoding) throws IOException {
        return this.getTemplate(name, this.getLocale(), encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding) throws IOException {
        return this.getTemplate(name, locale, encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parseAsFTL) throws IOException {
        return this.getTemplate(name, locale, encoding, parseAsFTL, false);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parseAsFTL, boolean ignoreMissing) throws IOException {
        Template result = this.cache.getTemplate(name, locale, encoding, parseAsFTL);
        if (result == null) {
            String msg;
            if (ignoreMissing) {
                return null;
            }
            TemplateLoader tl = this.getTemplateLoader();
            if (tl == null) {
                msg = "Don't know where to load template " + StringUtil.jQuote(name) + " from because the \"template_loader\" FreeMarker setting wasn't set.";
            } else {
                String tlDesc;
                msg = "Template " + StringUtil.jQuote(name) + " not found. " + "The quoted name was interpreted by this template loader: ";
                try {
                    tlDesc = tl.toString();
                }
                catch (Throwable e) {
                    tlDesc = tl.getClass().getName() + " object (toString failed)";
                }
                msg = msg + tlDesc + ".";
                if (!this.templateLoaderWasSet) {
                    msg = msg + " Note that the \"template_loader\" FreeMarker setting wasn't set, so it's on its default value, which is most certainly not intended and the cause of this problem.";
                }
            }
            throw new FileNotFoundException(msg);
        }
        return result;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding(Locale locale) {
        if (this.localeToCharsetMap.isEmpty()) {
            return this.defaultEncoding;
        }
        String charset = (String)this.localeToCharsetMap.get(locale.toString());
        if (charset == null) {
            Locale l;
            if (locale.getVariant().length() > 0 && (charset = (String)this.localeToCharsetMap.get((l = new Locale(locale.getLanguage(), locale.getCountry())).toString())) != null) {
                this.localeToCharsetMap.put(locale.toString(), charset);
            }
            if ((charset = (String)this.localeToCharsetMap.get(locale.getLanguage())) != null) {
                this.localeToCharsetMap.put(locale.toString(), charset);
            }
        }
        return charset != null ? charset : this.defaultEncoding;
    }

    public void setEncoding(Locale locale, String encoding) {
        this.localeToCharsetMap.put(locale.toString(), encoding);
    }

    public void setSharedVariable(String name, TemplateModel tm) {
        TemplateModel replaced = this.sharedVariables.put(name, tm);
        if (replaced != null && this.rewrappableSharedVariables != null) {
            this.rewrappableSharedVariables.remove(name);
        }
    }

    public Set getSharedVariableNames() {
        return new HashSet(this.sharedVariables.keySet());
    }

    public void setSharedVariable(String name, Object value) throws TemplateModelException {
        this.setSharedVariable(name, this.getObjectWrapper().wrap(value));
    }

    public void setSharedVaribles(Map map) throws TemplateModelException {
        this.rewrappableSharedVariables = new HashMap(map);
        this.sharedVariables.clear();
        this.setSharedVariablesFromRewrappableSharedVariables();
    }

    private void setSharedVariablesFromRewrappableSharedVariables() throws TemplateModelException {
        if (this.rewrappableSharedVariables == null) {
            return;
        }
        Iterator it = this.rewrappableSharedVariables.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            String name = (String)ent.getKey();
            Object value = ent.getValue();
            TemplateModel valueAsTM = value instanceof TemplateModel ? (TemplateModel)value : this.getObjectWrapper().wrap(value);
            this.sharedVariables.put(name, valueAsTM);
        }
    }

    public void setAllSharedVariables(TemplateHashModelEx hash) throws TemplateModelException {
        TemplateModelIterator keys = hash.keys().iterator();
        TemplateModelIterator values = hash.values().iterator();
        while (keys.hasNext()) {
            this.setSharedVariable(((TemplateScalarModel)keys.next()).getAsString(), values.next());
        }
    }

    public TemplateModel getSharedVariable(String name) {
        return (TemplateModel)this.sharedVariables.get(name);
    }

    public void clearSharedVariables() {
        this.sharedVariables.clear();
        this.loadBuiltInSharedVariables();
    }

    public void clearTemplateCache() {
        this.cache.clear();
    }

    public void removeTemplateFromCache(String name) throws IOException {
        Locale loc = this.getLocale();
        this.removeTemplateFromCache(name, loc, this.getEncoding(loc), true);
    }

    public void removeTemplateFromCache(String name, Locale locale) throws IOException {
        this.removeTemplateFromCache(name, locale, this.getEncoding(locale), true);
    }

    public void removeTemplateFromCache(String name, String encoding) throws IOException {
        this.removeTemplateFromCache(name, this.getLocale(), encoding, true);
    }

    public void removeTemplateFromCache(String name, Locale locale, String encoding) throws IOException {
        this.removeTemplateFromCache(name, locale, encoding, true);
    }

    public void removeTemplateFromCache(String name, Locale locale, String encoding, boolean parse) throws IOException {
        this.cache.removeTemplate(name, locale, encoding, parse);
    }

    public boolean getLocalizedLookup() {
        return this.cache.getLocalizedLookup();
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
        this.cache.setLocalizedLookup(localizedLookup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSetting(String name, String value) throws TemplateException {
        boolean unknown;
        block34: {
            unknown = false;
            try {
                if ("TemplateUpdateInterval".equalsIgnoreCase(name)) {
                    name = TEMPLATE_UPDATE_DELAY_KEY;
                } else if ("DefaultEncoding".equalsIgnoreCase(name)) {
                    name = DEFAULT_ENCODING_KEY;
                }
                if (DEFAULT_ENCODING_KEY.equals(name)) {
                    this.setDefaultEncoding(value);
                    break block34;
                }
                if (LOCALIZED_LOOKUP_KEY.equals(name)) {
                    this.setLocalizedLookup(StringUtil.getYesNo(value));
                    break block34;
                }
                if (STRICT_SYNTAX_KEY.equals(name)) {
                    this.setStrictSyntaxMode(StringUtil.getYesNo(value));
                    break block34;
                }
                if (WHITESPACE_STRIPPING_KEY.equals(name)) {
                    this.setWhitespaceStripping(StringUtil.getYesNo(value));
                    break block34;
                }
                if (CACHE_STORAGE_KEY.equals(name)) {
                    if (value.indexOf(46) == -1) {
                        int strongSize = 0;
                        int softSize = 0;
                        Map map = StringUtil.parseNameValuePairList(value, String.valueOf(Integer.MAX_VALUE));
                        Iterator it = map.entrySet().iterator();
                        while (it.hasNext()) {
                            int pvalue;
                            Map.Entry ent = it.next();
                            String pname = (String)ent.getKey();
                            try {
                                pvalue = Integer.parseInt((String)ent.getValue());
                            }
                            catch (NumberFormatException e) {
                                throw this.invalidSettingValueException(name, value);
                            }
                            if ("soft".equalsIgnoreCase(pname)) {
                                softSize = pvalue;
                                continue;
                            }
                            if (!"strong".equalsIgnoreCase(pname)) throw this.invalidSettingValueException(name, value);
                            strongSize = pvalue;
                        }
                        if (softSize == 0 && strongSize == 0) {
                            throw this.invalidSettingValueException(name, value);
                        }
                        this.setCacheStorage(new MruCacheStorage(strongSize, softSize));
                        break block34;
                    }
                    this.setCacheStorage((CacheStorage)_ObjectBuilderSettingEvaluator.eval(value, CacheStorage.class, _SettingEvaluationEnvironment.getCurrent()));
                    break block34;
                }
                if (TEMPLATE_UPDATE_DELAY_KEY.equals(name)) {
                    this.setTemplateUpdateDelay(Integer.parseInt(value));
                } else if (AUTO_INCLUDE_KEY.equals(name)) {
                    this.setAutoIncludes(this.parseAsList(value));
                } else if (AUTO_IMPORT_KEY.equals(name)) {
                    this.setAutoImports(this.parseAsImportList(value));
                } else if (TAG_SYNTAX_KEY.equals(name)) {
                    if ("auto_detect".equals(value)) {
                        this.setTagSyntax(0);
                    } else if ("angle_bracket".equals(value)) {
                        this.setTagSyntax(1);
                    } else {
                        if (!"square_bracket".equals(value)) throw this.invalidSettingValueException(name, value);
                        this.setTagSyntax(2);
                    }
                } else if (INCOMPATIBLE_IMPROVEMENTS.equals(name)) {
                    this.setIncompatibleImprovements(new Version(value));
                } else if (INCOMPATIBLE_ENHANCEMENTS.equals(name)) {
                    this.setIncompatibleEnhancements(value);
                } else if (TEMPLATE_LOADER_KEY.equals(name)) {
                    this.setTemplateLoader((TemplateLoader)_ObjectBuilderSettingEvaluator.eval(value, TemplateLoader.class, _SettingEvaluationEnvironment.getCurrent()));
                } else {
                    unknown = true;
                }
            }
            catch (Exception e) {
                throw this.settingValueAssignmentException(name, value, e);
            }
        }
        if (!unknown) return;
        super.setSetting(name, value);
    }

    protected String getCorrectedNameForUnknownSetting(String name) {
        if ("encoding".equals(name) || "charset".equals(name) || "default_charset".equals(name)) {
            return DEFAULT_ENCODING_KEY;
        }
        return super.getCorrectedNameForUnknownSetting(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoImport(String namespaceVarName, String templateName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoImports.remove(namespaceVarName);
            this.autoImports.add(namespaceVarName);
            this.autoImportNsToTmpMap.put(namespaceVarName, templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAutoImport(String namespaceVarName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoImports.remove(namespaceVarName);
            this.autoImportNsToTmpMap.remove(namespaceVarName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoImports(Map map) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoImports = new ArrayList(map.keySet());
            this.autoImportNsToTmpMap = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof SortedMap ? new TreeMap(map) : new HashMap(map));
        }
    }

    protected void doAutoImportsAndIncludes(Environment env) throws TemplateException, IOException {
        int i;
        for (i = 0; i < this.autoImports.size(); ++i) {
            String namespace = (String)this.autoImports.get(i);
            String templateName = (String)this.autoImportNsToTmpMap.get(namespace);
            env.importLib(templateName, namespace);
        }
        for (i = 0; i < this.autoIncludes.size(); ++i) {
            String templateName = (String)this.autoIncludes.get(i);
            Template template = this.getTemplate(templateName, env.getLocale());
            env.include(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoInclude(String templateName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoIncludes.remove(templateName);
            this.autoIncludes.add(templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoIncludes(List templateNames) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoIncludes.clear();
            Iterator it = templateNames.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("List items must be String-s.");
                }
                this.autoIncludes.add(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAutoInclude(String templateName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoIncludes.remove(templateName);
        }
    }

    public static String getVersionNumber() {
        return version.toString();
    }

    public static Version getVersion() {
        return version;
    }

    public static ObjectWrapper getDefaultObjectWrapper(Version incompatibleImprovements) {
        if (incompatibleImprovements.intValue() < _TemplateAPI.VERSION_INT_2_3_21) {
            return ObjectWrapper.DEFAULT_WRAPPER;
        }
        return new DefaultObjectWrapperBuilder(incompatibleImprovements).build();
    }

    public Set getSupportedBuiltInNames() {
        return _CoreAPI.getSupportedBuiltInNames();
    }

    public Set getSupportedBuiltInDirectiveNames() {
        return _CoreAPI.BUILT_IN_DIRECTIVE_NAMES;
    }

    private static String getRequiredVersionProperty(Properties vp, String properyName) {
        String s2 = vp.getProperty(properyName);
        if (s2 == null) {
            throw new RuntimeException("Version file is corrupt: \"" + properyName + "\" property is missing.");
        }
        return s2;
    }

    static {
        try {
            Date buildDate;
            Properties vp = new Properties();
            InputStream ins = Configuration.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES_PATH);
            if (ins == null) {
                throw new RuntimeException("Version file is missing.");
            }
            try {
                vp.load(ins);
            }
            finally {
                ins.close();
            }
            String versionString = Configuration.getRequiredVersionProperty(vp, "version");
            String buildDateStr = Configuration.getRequiredVersionProperty(vp, "buildTimestamp");
            if (buildDateStr.endsWith("Z")) {
                buildDateStr = buildDateStr.substring(0, buildDateStr.length() - 1) + "+0000";
            }
            try {
                buildDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US).parse(buildDateStr);
            }
            catch (ParseException e) {
                buildDate = null;
            }
            Boolean gaeCompliant = Boolean.valueOf(Configuration.getRequiredVersionProperty(vp, "isGAECompliant"));
            version = new Version(versionString, gaeCompliant, buildDate);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load and parse freemarker/version.properties", e);
        }
        defaultConfigLock = new Object();
    }
}

