/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.debug.impl;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;
import org.mapstruct.ap.shaded.freemarker.debug.DebugModel;
import org.mapstruct.ap.shaded.freemarker.debug.impl.RmiDebuggedEnvironmentImpl;
import org.mapstruct.ap.shaded.freemarker.template.TemplateBooleanModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateCollectionModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateDateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateHashModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateHashModelEx;
import org.mapstruct.ap.shaded.freemarker.template.TemplateMethodModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateMethodModelEx;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelIterator;
import org.mapstruct.ap.shaded.freemarker.template.TemplateNumberModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateScalarModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateSequenceModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateTransformModel;

class RmiDebugModelImpl
extends UnicastRemoteObject
implements DebugModel {
    private static final long serialVersionUID = 1L;
    private final TemplateModel model;
    private final int type;

    RmiDebugModelImpl(TemplateModel model, int extraTypes) throws RemoteException {
        this.model = model;
        this.type = RmiDebugModelImpl.calculateType(model) + extraTypes;
    }

    private static DebugModel getDebugModel(TemplateModel tm) throws RemoteException {
        return (DebugModel)RmiDebuggedEnvironmentImpl.getCachedWrapperFor(tm);
    }

    public String getAsString() throws TemplateModelException {
        return ((TemplateScalarModel)this.model).getAsString();
    }

    public Number getAsNumber() throws TemplateModelException {
        return ((TemplateNumberModel)this.model).getAsNumber();
    }

    public Date getAsDate() throws TemplateModelException {
        return ((TemplateDateModel)this.model).getAsDate();
    }

    public int getDateType() {
        return ((TemplateDateModel)this.model).getDateType();
    }

    public boolean getAsBoolean() throws TemplateModelException {
        return ((TemplateBooleanModel)this.model).getAsBoolean();
    }

    public int size() throws TemplateModelException {
        if (this.model instanceof TemplateSequenceModel) {
            return ((TemplateSequenceModel)this.model).size();
        }
        return ((TemplateHashModelEx)this.model).size();
    }

    public DebugModel get(int index) throws TemplateModelException, RemoteException {
        return RmiDebugModelImpl.getDebugModel(((TemplateSequenceModel)this.model).get(index));
    }

    public DebugModel[] get(int fromIndex, int toIndex) throws TemplateModelException, RemoteException {
        DebugModel[] dm = new DebugModel[toIndex - fromIndex];
        TemplateSequenceModel s2 = (TemplateSequenceModel)this.model;
        for (int i = fromIndex; i < toIndex; ++i) {
            dm[i - fromIndex] = RmiDebugModelImpl.getDebugModel(s2.get(i));
        }
        return dm;
    }

    public DebugModel[] getCollection() throws TemplateModelException, RemoteException {
        ArrayList<DebugModel> list = new ArrayList<DebugModel>();
        TemplateModelIterator i = ((TemplateCollectionModel)this.model).iterator();
        while (i.hasNext()) {
            list.add(RmiDebugModelImpl.getDebugModel(i.next()));
        }
        return list.toArray(new DebugModel[list.size()]);
    }

    public DebugModel get(String key) throws TemplateModelException, RemoteException {
        return RmiDebugModelImpl.getDebugModel(((TemplateHashModel)this.model).get(key));
    }

    public DebugModel[] get(String[] keys) throws TemplateModelException, RemoteException {
        DebugModel[] dm = new DebugModel[keys.length];
        TemplateHashModel h2 = (TemplateHashModel)this.model;
        for (int i = 0; i < keys.length; ++i) {
            dm[i] = RmiDebugModelImpl.getDebugModel(h2.get(keys[i]));
        }
        return dm;
    }

    public String[] keys() throws TemplateModelException {
        TemplateHashModelEx h2 = (TemplateHashModelEx)this.model;
        ArrayList<String> list = new ArrayList<String>();
        TemplateModelIterator i = h2.keys().iterator();
        while (i.hasNext()) {
            list.add(((TemplateScalarModel)i.next()).getAsString());
        }
        return list.toArray(new String[list.size()]);
    }

    public int getModelTypes() {
        return this.type;
    }

    private static int calculateType(TemplateModel model) {
        int type = 0;
        if (model instanceof TemplateScalarModel) {
            ++type;
        }
        if (model instanceof TemplateNumberModel) {
            type += 2;
        }
        if (model instanceof TemplateDateModel) {
            type += 4;
        }
        if (model instanceof TemplateBooleanModel) {
            type += 8;
        }
        if (model instanceof TemplateSequenceModel) {
            type += 16;
        }
        if (model instanceof TemplateCollectionModel) {
            type += 32;
        }
        if (model instanceof TemplateHashModelEx) {
            type += 128;
        } else if (model instanceof TemplateHashModel) {
            type += 64;
        }
        if (model instanceof TemplateMethodModelEx) {
            type += 512;
        } else if (model instanceof TemplateMethodModel) {
            type += 256;
        }
        if (model instanceof TemplateTransformModel) {
            type += 1024;
        }
        return type;
    }
}

