/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.util.Date;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.Macro;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.ParseException;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.template.Configuration;
import org.mapstruct.ap.shaded.freemarker.template.SimpleDate;
import org.mapstruct.ap.shaded.freemarker.template.SimpleScalar;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateHashModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;

final class BuiltinVariable
extends Expression {
    static final String TEMPLATE_NAME = "template_name";
    static final String NAMESPACE = "namespace";
    static final String MAIN = "main";
    static final String GLOBALS = "globals";
    static final String LOCALS = "locals";
    static final String DATA_MODEL = "data_model";
    static final String LANG = "lang";
    static final String LOCALE = "locale";
    static final String LOCALE_OBJECT = "locale_object";
    static final String CURRENT_NODE = "current_node";
    static final String NODE = "node";
    static final String PASS = "pass";
    static final String VARS = "vars";
    static final String VERSION = "version";
    static final String ERROR = "error";
    static final String OUTPUT_ENCODING = "output_encoding";
    static final String URL_ESCAPING_CHARSET = "url_escaping_charset";
    static final String NOW = "now";
    private final String name;

    BuiltinVariable(String name) throws ParseException {
        this.name = name = name.intern();
        if (name != TEMPLATE_NAME && name != NAMESPACE && name != MAIN && name != GLOBALS && name != LOCALS && name != LANG && name != LOCALE && name != LOCALE_OBJECT && name != DATA_MODEL && name != CURRENT_NODE && name != NODE && name != PASS && name != VARS && name != VERSION && name != OUTPUT_ENCODING && name != URL_ESCAPING_CHARSET && name != ERROR && name != NOW) {
            throw new ParseException("Unknown built-in variable: " + name, this);
        }
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        if (this.name == NAMESPACE) {
            return env.getCurrentNamespace();
        }
        if (this.name == MAIN) {
            return env.getMainNamespace();
        }
        if (this.name == GLOBALS) {
            return env.getGlobalVariables();
        }
        if (this.name == LOCALS) {
            Macro.Context ctx = env.getCurrentMacroContext();
            return ctx == null ? null : ctx.getLocals();
        }
        if (this.name == DATA_MODEL) {
            return env.getDataModel();
        }
        if (this.name == VARS) {
            return new VarsHash(env);
        }
        if (this.name == LOCALE) {
            return new SimpleScalar(env.getLocale().toString());
        }
        if (this.name == LOCALE_OBJECT) {
            return env.getObjectWrapper().wrap(env.getLocale());
        }
        if (this.name == LANG) {
            return new SimpleScalar(env.getLocale().getLanguage());
        }
        if (this.name == CURRENT_NODE || this.name == NODE) {
            return env.getCurrentVisitorNode();
        }
        if (this.name == TEMPLATE_NAME) {
            return new SimpleScalar(env.getTemplate().getName());
        }
        if (this.name == PASS) {
            return Macro.DO_NOTHING_MACRO;
        }
        if (this.name == VERSION) {
            return new SimpleScalar(Configuration.getVersionNumber());
        }
        if (this.name == OUTPUT_ENCODING) {
            String s2 = env.getOutputEncoding();
            return s2 != null ? new SimpleScalar(s2) : null;
        }
        if (this.name == URL_ESCAPING_CHARSET) {
            String s3 = env.getURLEscapingCharset();
            return s3 != null ? new SimpleScalar(s3) : null;
        }
        if (this.name == ERROR) {
            return new SimpleScalar(env.getCurrentRecoveredErrorMessage());
        }
        if (this.name == NOW) {
            return new SimpleDate(new Date(), 3);
        }
        throw new _MiscTemplateException((Expression)this, new Object[]{"Invalid built-in variable: ", this.name});
    }

    public String toString() {
        return "." + this.name;
    }

    public String getCanonicalForm() {
        return "." + this.name;
    }

    String getNodeTypeSymbol() {
        return this.getCanonicalForm();
    }

    boolean isLiteral() {
        return false;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return this;
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    static class VarsHash
    implements TemplateHashModel {
        Environment env;

        VarsHash(Environment env) {
            this.env = env;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            return this.env.getVariable(key);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

