/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.util.infra.util;

import io.sitoolkit.wt.util.infra.UnExpectedException;
import io.sitoolkit.wt.util.infra.concurrent.ExecutorContainer;
import io.sitoolkit.wt.util.infra.process.StdoutListener;
import io.sitoolkit.wt.util.infra.process.StdoutListenerContainer;
import io.sitoolkit.wt.util.infra.util.Stopwatch;
import io.sitoolkit.wt.util.infra.util.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;

public class FileIOUtils {
    private static final Logger LOG = Logger.getLogger(FileIOUtils.class.getName());
    private static final int PERM_OWNER_R = 256;
    private static final int PERM_OWNER_W = 128;
    private static final int PERM_OWNER_X = 64;
    private static final int PERM_GROUP_R = 32;
    private static final int PERM_GROUP_W = 16;
    private static final int PERM_GROUP_X = 8;
    private static final int PERM_OTHER_R = 4;
    private static final int PERM_OTHER_W = 2;
    private static final int PERM_OTHER_X = 1;
    private static final String READABLE = "r";
    private static final String WRITABLE = "w";
    private static final String EXECUTABLE = "x";
    private static final String DISABLE = "-";

    public static void download(String url, File destFile) {
        Stopwatch.start();
        LOG.log(Level.INFO, "downloading url : {0}, destFile : {1}", new Object[]{url, destFile.getAbsolutePath()});
        File destDir = destFile.getParentFile();
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        URLConnection conn = null;
        try {
            conn = new URL(url).openConnection();
        }
        catch (IOException e) {
            throw new UnExpectedException(e);
        }
        DownloadWatcher watcher = new DownloadWatcher(conn.getContentLength(), destFile);
        ExecutorContainer.get().execute(watcher);
        try (InputStream stream = conn.getInputStream();){
            Files.copy(stream, destFile.toPath(), new CopyOption[0]);
            watcher.downloaded = true;
        }
        catch (IOException e) {
            throw new UnExpectedException(e);
        }
        LOG.log(Level.INFO, "downloaded in {0}", Stopwatch.end());
    }

    public static void unarchive(File srcFile, File destDir) {
        Stopwatch.start();
        LOG.log(Level.INFO, "unarchive src : {0}, dest : {1}", new Object[]{srcFile.getAbsolutePath(), destDir.getAbsolutePath()});
        try (ZipFile zipFile = new ZipFile(srcFile);){
            Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = entries.nextElement();
                Path destFile = Paths.get(destDir.getAbsolutePath(), zipEntry.getName());
                if (zipEntry.isUnixSymlink()) {
                    Path linkTarget = Paths.get(zipFile.getUnixSymlink(zipEntry), new String[0]);
                    Files.createSymbolicLink(destFile, linkTarget, new FileAttribute[0]);
                } else if (zipEntry.isDirectory()) {
                    Files.createDirectories(destFile, new FileAttribute[0]);
                } else {
                    try (OutputStream destFileStream = Files.newOutputStream(destFile, new OpenOption[0]);){
                        IOUtils.copy(zipFile.getInputStream(zipEntry), destFileStream);
                    }
                }
                if (!SystemUtils.isOsX() || zipEntry.isUnixSymlink()) continue;
                Files.setPosixFilePermissions(destFile, FileIOUtils.convertPermission(zipEntry.getUnixMode()));
            }
        }
        catch (IOException e) {
            throw new UnExpectedException(e);
        }
        LOG.log(Level.INFO, "unarchived in {0}", Stopwatch.end());
    }

    private static Set<PosixFilePermission> convertPermission(int permission) {
        StringBuilder permissionStr = new StringBuilder();
        permissionStr.append((0x100 & permission) > 0 ? READABLE : DISABLE);
        permissionStr.append((0x80 & permission) > 0 ? WRITABLE : DISABLE);
        permissionStr.append((0x40 & permission) > 0 ? EXECUTABLE : DISABLE);
        permissionStr.append((0x20 & permission) > 0 ? READABLE : DISABLE);
        permissionStr.append((0x10 & permission) > 0 ? WRITABLE : DISABLE);
        permissionStr.append((8 & permission) > 0 ? EXECUTABLE : DISABLE);
        permissionStr.append((4 & permission) > 0 ? READABLE : DISABLE);
        permissionStr.append((2 & permission) > 0 ? WRITABLE : DISABLE);
        permissionStr.append((1 & permission) > 0 ? EXECUTABLE : DISABLE);
        return PosixFilePermissions.fromString(permissionStr.toString());
    }

    public static String read(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static String file2str(File file) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            br.lines().forEach(line -> {
                sb.append((String)line);
                sb.append(System.lineSeparator());
            });
        }
        catch (IOException e) {
            throw new UnExpectedException(e);
        }
        return sb.toString();
    }

    public static void copy(File src, File dst) {
        LOG.log(Level.INFO, "{0} copy to {1}", new Object[]{src.getAbsolutePath(), dst.getAbsolutePath()});
        try {
            Files.copy(src.toPath(), dst.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UnExpectedException(e);
        }
    }

    public static void copyDirectoryWithPermission(Path src, Path parent) {
        block10: {
            try {
                Path dst = Paths.get(parent.toString(), src.toFile().getName());
                Files.copy(src, dst, StandardCopyOption.COPY_ATTRIBUTES);
                if (!Files.isDirectory(src, new LinkOption[0])) break block10;
                try (Stream<Path> children = Files.list(src);){
                    children.forEach(child -> FileIOUtils.copyDirectoryWithPermission(child, dst));
                }
                catch (IOException e) {
                    throw new UnExpectedException(e);
                }
            }
            catch (IOException e) {
                throw new UnExpectedException(e);
            }
        }
    }

    public static void sysRes2file(String resourceName, Path targetPath) {
        FileIOUtils.sysRes2file(resourceName, targetPath, false);
    }

    public static void sysRes2file(String resourceName, Path targetPath, boolean deleteOnExit) {
        URL resourceUrl = ClassLoader.getSystemResource(resourceName);
        try {
            File targetFile = targetPath.toFile();
            if (deleteOnExit) {
                targetFile.deleteOnExit();
            }
            FileUtils.copyURLToFile(resourceUrl, targetFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void main(String[] args) {
        FileIOUtils.download("https://github.com/sitoolkit/sit-wt-all/releases/download/v2.0/maven-repository-sit-wt.zip", new File("./temp.zip"));
    }

    static class DownloadWatcher
    implements Runnable {
        boolean downloaded = false;
        int contentLength;
        File destFile;

        DownloadWatcher(int contentLength, File destFile) {
            this.contentLength = contentLength;
            this.destFile = destFile;
        }

        @Override
        public void run() {
            for (StdoutListener listener : StdoutListenerContainer.get().getListeners()) {
                listener.nextLine("downloading " + this.destFile.getAbsolutePath());
            }
            while (!this.downloaded) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.WARNING, "", e);
                    Thread.currentThread().interrupt();
                }
                String log = "downloaded " + this.destFile.length() / 1024L + " / " + this.contentLength / 1024 + " KB";
                for (StdoutListener listener : StdoutListenerContainer.get().getListeners()) {
                    listener.nextLine(log);
                }
                LOG.log(Level.INFO, log);
            }
        }
    }
}

