/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.util.infra.process;

import io.sitoolkit.wt.util.infra.UnExpectedException;
import io.sitoolkit.wt.util.infra.concurrent.ExecutorContainer;
import io.sitoolkit.wt.util.infra.process.LogStdoutListener;
import io.sitoolkit.wt.util.infra.process.NopProcessExitCallback;
import io.sitoolkit.wt.util.infra.process.ProcessExitCallback;
import io.sitoolkit.wt.util.infra.process.ProcessParams;
import io.sitoolkit.wt.util.infra.process.StdoutListener;
import io.sitoolkit.wt.util.infra.process.StdoutListenerContainer;
import io.sitoolkit.wt.util.infra.process.StringBuilderStdoutListener;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConversationProcess {
    private static final Logger LOG = Logger.getLogger(ConversationProcess.class.getName());
    private static final LogStdoutListener LOG_STDOUT_LISTENER = new LogStdoutListener(LOG, Level.INFO, "stdout");
    private static final LogStdoutListener LOG_STDERR_LISTENER = new LogStdoutListener(LOG, Level.SEVERE, "stderr");
    private Process process;
    private PrintWriter processWriter;
    private StringBuilderStdoutListener defaultStderrListener = new StringBuilderStdoutListener();

    ConversationProcess() {
    }

    public void startWithProcessWait(ProcessParams params) {
        if (params.getExitClallbacks().isEmpty()) {
            params.getExitClallbacks().add(new NopProcessExitCallback());
        }
        params.setProcessWait(true);
        this.start(params);
    }

    public void start(ProcessParams params) {
        File directory = params.getDirectory();
        if (directory == null) {
            directory = ProcessParams.getDefaultCurrentDir();
        }
        List<String> command = params.getCommand();
        if (this.process != null && this.process.isAlive()) {
            LOG.log(Level.WARNING, "process {0} is alive.", this.process);
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.environment().putAll(params.getEnviroment());
        try {
            pb.directory(directory);
            this.process = pb.start();
            LOG.log(Level.INFO, "process {0} starts {1}", new Object[]{this.process, command});
            ArrayList<StdoutListener> stdoutListeners = new ArrayList<StdoutListener>();
            stdoutListeners.add(LOG_STDOUT_LISTENER);
            stdoutListeners.addAll(params.getStdoutListeners());
            stdoutListeners.addAll(StdoutListenerContainer.get().getListeners());
            ArrayList<StdoutListener> stderrListeners = new ArrayList<StdoutListener>();
            stderrListeners.add(LOG_STDERR_LISTENER);
            if (params.isProcessWait()) {
                this.scan(this.process.getInputStream(), stdoutListeners);
                this.scan(this.process.getErrorStream(), stderrListeners);
            } else {
                ExecutorContainer.get().execute(() -> this.scan(this.process.getInputStream(), stdoutListeners));
                ExecutorContainer.get().execute(() -> this.scan(this.process.getErrorStream(), stderrListeners));
            }
            this.processWriter = new PrintWriter(this.process.getOutputStream());
            if (params.isProcessWait()) {
                this.wait(params.getExitClallbacks());
            } else {
                ExecutorContainer.get().execute(() -> this.wait(params.getExitClallbacks()));
            }
        }
        catch (Exception e) {
            throw new UnExpectedException(e);
        }
    }

    private void scan(InputStream is, List<StdoutListener> listeners) {
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            for (StdoutListener listener : listeners) {
                listener.nextLine(line);
            }
        }
        scanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait(List<ProcessExitCallback> callbacks) {
        int exitCode;
        block11: {
            exitCode = 0;
            try {
                exitCode = this.process.waitFor();
                LOG.log(Level.INFO, "process {0} exits with code : {1}", new Object[]{this.process, exitCode});
                if (exitCode == 0) break block11;
            }
            catch (InterruptedException e) {
                block12: {
                    try {
                        LOG.log(Level.WARNING, "", e);
                        if (exitCode == 0) break block12;
                    }
                    catch (Throwable throwable) {
                        if (exitCode != 0) {
                            LOG.log(Level.SEVERE, "{0} {1}", new Object[]{System.lineSeparator(), this.defaultStderrListener});
                        }
                        if (callbacks != null) {
                            for (ProcessExitCallback callback : callbacks) {
                                callback.callback(exitCode);
                            }
                        }
                        throw throwable;
                    }
                    LOG.log(Level.SEVERE, "{0} {1}", new Object[]{System.lineSeparator(), this.defaultStderrListener});
                }
                if (callbacks != null) {
                    for (ProcessExitCallback callback : callbacks) {
                        callback.callback(exitCode);
                    }
                }
            }
            LOG.log(Level.SEVERE, "{0} {1}", new Object[]{System.lineSeparator(), this.defaultStderrListener});
        }
        if (callbacks != null) {
            for (ProcessExitCallback callback : callbacks) {
                callback.callback(exitCode);
            }
        }
    }

    public void input(String input) {
        this.processWriter.println(input);
        this.processWriter.flush();
    }

    public void destroy() {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
        }
    }
}

