/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra.chromium;

import io.sitoolkit.util.buildtoolhelper.proxysetting.ProxySettingService;
import io.sitoolkit.wt.infra.MultiThreadUtils;
import io.sitoolkit.wt.infra.PropertyUtils;
import io.sitoolkit.wt.infra.SitRepository;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import io.sitoolkit.wt.util.infra.util.FileIOUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jsoup.UncheckedIOException;

public class ChromiumManager {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(ChromiumManager.class);
    private Path repositoryDir;
    private Path installDir;
    private String chromiumInstaller;
    private String chromiumUrl;
    private Path chromiumVersionFile;
    private Path chromiumBinary;
    private String seleniumIdeUrl;
    private String seleniumIdeInstaller;

    @PostConstruct
    public void init() {
        Map<String, String> prop = PropertyUtils.loadAsMap("/chromiuminstaller.properties", false);
        this.repositoryDir = Paths.get(SitRepository.getRepositoryPath(), "chromium");
        this.seleniumIdeInstaller = prop.get("seleniumIde.installer");
        this.seleniumIdeUrl = prop.get("seleniumIde.url");
        String version = prop.get("chromium.version");
        if (SystemUtils.IS_OS_WINDOWS) {
            this.installDir = Paths.get(this.repositoryDir.toString(), "chrome-win");
            this.chromiumInstaller = prop.get("win.chromium.installer");
            this.chromiumUrl = prop.get("win.chromium.url");
            this.chromiumVersionFile = Paths.get(this.installDir.toString(), version + ".manifest");
            this.chromiumBinary = Paths.get(this.installDir.toString(), "chrome.exe");
        } else if (SystemUtils.IS_OS_MAC) {
            this.installDir = Paths.get(this.repositoryDir.toString(), "chrome-mac");
            this.chromiumInstaller = prop.get("mac.chromium.installer");
            this.chromiumUrl = prop.get("mac.chromium.url");
            this.chromiumVersionFile = Paths.get(this.installDir.toString(), "Chromium.app/Contents/Frameworks/Chromium Framework.framework/Versions", version);
            this.chromiumBinary = Paths.get(this.installDir.toString(), "Chromium.app/Contents/MacOS/Chromium");
        } else {
            throw new UnsupportedOperationException(MessageManager.getMessage("os.unsupport"));
        }
    }

    public Path getBinary() {
        if (Files.exists(this.chromiumBinary, new LinkOption[0])) {
            if (this.expectedVersion()) {
                LOG.info("chromium.exist", this.chromiumBinary.toString());
            } else {
                this.uninstall();
                this.install();
            }
        } else {
            LOG.info("chromium.sit.install");
            this.install();
        }
        return this.chromiumBinary;
    }

    private boolean expectedVersion() {
        return Files.exists(this.chromiumVersionFile, new LinkOption[0]);
    }

    private void install() {
        Path installer = Paths.get(this.repositoryDir.toString(), this.chromiumInstaller);
        if (Files.exists(installer, new LinkOption[0])) {
            LOG.info("chromium.installer.exists", installer.toString());
        } else {
            try {
                ProxySettingService.getInstance().loadProxy();
                URL url = new URL(this.chromiumUrl);
                LOG.info("chromium.download", url, installer.toString());
                MultiThreadUtils.submitWithProgress(() -> {
                    FileUtils.copyURLToFile(url, installer.toFile());
                    return 0;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LOG.info("chromium.install");
        FileIOUtils.unarchive(installer.toFile(), this.repositoryDir.toFile());
    }

    private void uninstall() {
        try {
            LOG.info("chromium.uninstall");
            FileUtils.cleanDirectory(this.installDir.toFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path getSeleniumIde() {
        Path ide = Paths.get(this.getSeleniumIdeRepository().toString(), this.seleniumIdeInstaller);
        if (Files.exists(ide, new LinkOption[0])) {
            LOG.info("selenium.exist", ide.toString());
        } else {
            try {
                ProxySettingService.getInstance().loadProxy();
                URL url = new URL(this.seleniumIdeUrl);
                LOG.info("selenium.download", url, ide.toString());
                FileUtils.copyURLToFile(url, ide.toFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return ide;
    }

    private Path getSeleniumIdeRepository() {
        Path repo = Paths.get(SitRepository.getRepositoryPath(), "selenium/ide");
        if (!Files.exists(repo, new LinkOption[0])) {
            try {
                Files.createDirectories(repo, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return repo;
    }
}

