/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.infra;

import io.sitoolkit.wt.infra.TestException;
import java.io.File;
import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;

public class SitPathUtils {
    private static final String LOCAL_BASE_URL = "src/main/webapp";

    public static String relatvePath(File parent, File child) {
        return parent.toURI().relativize(child.toURI()).getPath();
    }

    public static String relatvePath(String parent, String child) {
        return SitPathUtils.relatvePath(new File(parent), new File(child));
    }

    public static String buildUrl(String baseUrl, String path) {
        if (path.startsWith("http:") || path.startsWith("https:")) {
            return path;
        }
        if (StringUtils.isEmpty(baseUrl)) {
            return SitPathUtils.file2url(SitPathUtils.concatPath(LOCAL_BASE_URL, path));
        }
        if (baseUrl.startsWith("http:") || baseUrl.startsWith("https:")) {
            return SitPathUtils.concatPath(baseUrl, path);
        }
        return SitPathUtils.concatPath(SitPathUtils.file2url(baseUrl), path);
    }

    public static String file2url(String path) {
        try {
            return new File(path).toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new TestException(e);
        }
    }

    public static String concatPath(String a, String b) {
        return a.endsWith("/") ? a + b : a + "/" + b;
    }
}

