/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript.rule;

import io.sitoolkit.wt.gui.pres.editor.testscript.rule.InputRule;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class OkCancelRule
implements InputRule {
    private static final String BLANK = "";
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";
    private static final Pattern OK_PATTERN = Pattern.compile("(ok|true|y)", 2);
    private static List<String> items = Arrays.asList("", "ok", "cancel");
    private static final OkCancelRule instance = new OkCancelRule();

    @Override
    public boolean match(String value) {
        return true;
    }

    @Override
    public boolean isChangeable() {
        return this.isChooseable();
    }

    @Override
    public String defalutValue() {
        return BLANK;
    }

    @Override
    public List<String> getChoices() {
        return items;
    }

    @Override
    public String convertValue(String value) {
        if (StringUtils.isBlank(value)) {
            return BLANK;
        }
        Matcher matcher = OK_PATTERN.matcher(value);
        return matcher.find() ? OK : CANCEL;
    }

    @Generated
    private OkCancelRule() {
    }

    @Generated
    public static OkCancelRule getInstance() {
        return instance;
    }
}

