/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript.rule;

import io.sitoolkit.wt.domain.testscript.ScreenshotTiming;
import io.sitoolkit.wt.domain.testscript.TestStepInputType;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.DisabledRule;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.FreeRule;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.InputRule;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.OkCancelRule;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.ValueListRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class InputRuleProvider {
    private final InputRule noRule = FreeRule.getInstance();
    private final InputRule itemNameRule = FreeRule.getInstance();
    private final InputRule operationNameRule = InputRuleProvider.createOperationNameRule();
    private final InputRule screenshotTimingRule = new ValueListRule(ScreenshotTiming.getLabels());
    private final InputRule breakpointRule = DisabledRule.getInstance();
    private final Map<String, InputRule> locatorTypeRules = new HashMap<String, InputRule>();
    private final Map<String, InputRule> locatorRules = new HashMap<String, InputRule>();
    private final Map<String, InputRule> dataTypeRules = new HashMap<String, InputRule>();
    private final Map<String, InputRule> testDataRules = new HashMap<String, InputRule>();

    public InputRule getLocatorTypeRule(String operationName) {
        return this.locatorTypeRules.computeIfAbsent(operationName, this::createLocatorTypeRule);
    }

    public InputRule getLocatorRule(String operationName) {
        return this.locatorRules.computeIfAbsent(operationName, this::createLocatorRule);
    }

    public InputRule getDataTypeRule(String operationName) {
        return this.dataTypeRules.computeIfAbsent(operationName, this::createDataTypeRule);
    }

    public InputRule getTestDataRule(String operationName) {
        return this.testDataRules.computeIfAbsent(operationName, this::createTestDataRule);
    }

    public static InputRule createOperationNameRule() {
        List<String> operationNames = Stream.of(TestStepInputType.values()).map(TestStepInputType::getOperationName).collect(Collectors.toList());
        return new ValueListRule(operationNames);
    }

    public InputRule createLocatorTypeRule(String operationName) {
        List<String> locatorTypes = TestStepInputType.decode(operationName).getLocatorTypes();
        return new ValueListRule(locatorTypes);
    }

    public InputRule createLocatorRule(String operationName) {
        List<String> locatorTypes = TestStepInputType.decode(operationName).getLocatorTypes();
        if (locatorTypes.size() == 1 && locatorTypes.get(0).equals("")) {
            return DisabledRule.getInstance();
        }
        return FreeRule.getInstance();
    }

    public InputRule createDataTypeRule(String operationName) {
        List<String> dataTypes = TestStepInputType.decode(operationName).getDataTypes();
        return new ValueListRule(dataTypes);
    }

    public InputRule createTestDataRule(String operationName) {
        List<String> dataTypes = TestStepInputType.decode(operationName).getDataTypes();
        switch (dataTypes.get(0)) {
            case "ok_cancel": {
                return OkCancelRule.getInstance();
            }
            case "na": {
                return DisabledRule.getInstance();
            }
        }
        return FreeRule.getInstance();
    }

    @Generated
    public InputRuleProvider() {
    }

    @Generated
    public InputRule getNoRule() {
        return this.noRule;
    }

    @Generated
    public InputRule getItemNameRule() {
        return this.itemNameRule;
    }

    @Generated
    public InputRule getOperationNameRule() {
        return this.operationNameRule;
    }

    @Generated
    public InputRule getScreenshotTimingRule() {
        return this.screenshotTimingRule;
    }

    @Generated
    public InputRule getBreakpointRule() {
        return this.breakpointRule;
    }
}

