/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript;

import io.sitoolkit.wt.domain.debug.DebugListener;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.gui.app.script.ScriptService;
import io.sitoolkit.wt.gui.pres.editor.EditorController;
import io.sitoolkit.wt.gui.pres.editor.testscript.TestScriptEditor;
import io.sitoolkit.wt.gui.pres.editor.testscript.TestScriptEditorFxImpl;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import lombok.NonNull;

public class TestScriptEditorController
implements EditorController,
DebugListener {
    private TestScriptEditor editor = new TestScriptEditorFxImpl();
    private MenuState menuState = new MenuState();
    @NonNull
    private ScriptService scriptService;

    public TestScriptEditorController(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Override
    public void open(Path file) {
        TestScript testScript = this.scriptService.read(file.toFile());
        this.editor.load(testScript);
        this.editor.getContextMenu().getItems().addAll((Collection<MenuItem>)this.createMenuItems());
        this.editor.getContextMenu().setOnShowing(e -> this.updateManuState());
    }

    @Override
    public void save() {
        TestScript testScript = this.editor.buildTestScript();
        this.scriptService.write(testScript);
    }

    @Override
    public Optional<Node> getEditorContent() {
        return Optional.of(this.editor.getSpreadSheet());
    }

    @Override
    public void saveAs(Path file) {
        TestScript testScript = this.editor.buildTestScript();
        testScript.setScriptFile(file.toFile());
        this.scriptService.write(testScript);
    }

    @Override
    public void onDebugging(Path scriptPath, int nextStepIndex, int caseIndex) {
        this.editor.setDebugStyle(nextStepIndex, caseIndex);
    }

    @Override
    public void onCaseEnd(Path scriptPath, int caseIndex) {
        this.editor.removeDebugStyle();
    }

    @Override
    public void onClose() {
        this.editor.removeDebugStyle();
    }

    public void newTestCase(ActionEvent e) {
        this.editor.insertTestCase();
    }

    public void newTestStep(ActionEvent e) {
        this.editor.insertTestStep();
    }

    public void newTestCaseTail(ActionEvent e) {
        this.editor.appendTestCase();
    }

    public void newTestStepTail(ActionEvent e) {
        this.editor.appendTestStep();
    }

    public void copy(ActionEvent e) {
        this.editor.getClipboardAccessor().copy();
    }

    public void paste(ActionEvent e) {
        this.editor.getClipboardAccessor().paste();
    }

    public void insertAndPasteCase(ActionEvent e) {
        int count = this.editor.getClipboardAccessor().getClipboardCaseCount();
        if (count > 0) {
            this.editor.insertTestCases(count);
            this.editor.getClipboardAccessor().paste();
        }
    }

    public void insertAndPasteStep(ActionEvent e) {
        int count = this.editor.getClipboardAccessor().getClipboardStepCount();
        if (count > 0) {
            this.editor.insertTestSteps(count);
            this.editor.getClipboardAccessor().paste();
        }
    }

    public void appendAndPasteCase(ActionEvent e) {
        int count = this.editor.getClipboardAccessor().getClipboardCaseCount();
        if (count > 0) {
            this.editor.appendTestCases(count);
            this.editor.getClipboardAccessor().paste();
        }
    }

    public void appendAndPasteStep(ActionEvent e) {
        int count = this.editor.getClipboardAccessor().getClipboardStepCount();
        if (count > 0) {
            this.editor.appendTestSteps(count);
            this.editor.getClipboardAccessor().paste();
        }
    }

    public void deleteCase(ActionEvent e) {
        this.editor.deleteTestCase();
    }

    public void deleteStep(ActionEvent e) {
        this.editor.deleteTestStep();
    }

    private void updateManuState() {
        this.menuState.getClipboardPastable().set(this.clipboardPastable());
        this.menuState.getClipboardHasCase().set(this.hasClipboardCases());
        this.menuState.getClipboardHasStep().set(this.hasClipboardSteps());
        this.menuState.getCellSelected().set(this.editor.isCellSelected());
        this.menuState.getCaseSelected().set(this.editor.isCaseSelected());
        this.menuState.getStepSelected().set(this.editor.isStepSelected());
        this.menuState.getCaseInsertable().set(this.editor.isCaseInsertable());
        this.menuState.getStepInsertable().set(this.editor.isStepInsertable());
    }

    public void toggleBreakpoint(ActionEvent e) {
        this.editor.toggleBreakpoint();
    }

    private ObservableList<MenuItem> createMenuItems() {
        ObservableList<MenuItem> menuItems = FXCollections.observableArrayList();
        KeyCodeCombination keyCodeCopy = new KeyCodeCombination(KeyCode.C, KeyCombination.SHORTCUT_DOWN);
        KeyCodeCombination keyCodePaste = new KeyCodeCombination(KeyCode.V, KeyCombination.SHORTCUT_DOWN);
        MenuItem item = new MenuItem("\u30b3\u30d4\u30fc");
        item.setMnemonicParsing(false);
        item.setOnAction(this::copy);
        item.disableProperty().bind(this.menuState.getCellSelected().not());
        item.setAccelerator(keyCodeCopy);
        menuItems.add(item);
        item = new MenuItem("\u8cbc\u308a\u4ed8\u3051");
        item.setMnemonicParsing(false);
        item.setOnAction(this::paste);
        item.disableProperty().bind(this.menuState.getClipboardPastable().not());
        item.setAccelerator(keyCodePaste);
        menuItems.add(item);
        menuItems.add(new SeparatorMenuItem());
        Menu menu = new Menu("\u633f\u5165");
        item = new MenuItem("\u65b0\u898f\u30b1\u30fc\u30b9\u306e\u633f\u5165");
        item.setMnemonicParsing(false);
        item.setOnAction(this::newTestCase);
        item.disableProperty().bind(this.menuState.getCaseInsertable().not());
        menu.getItems().add(item);
        item = new MenuItem("\u30b3\u30d4\u30fc\u3057\u305f\u30b1\u30fc\u30b9\u306e\u633f\u5165");
        item.setMnemonicParsing(false);
        item.setOnAction(this::insertAndPasteCase);
        item.disableProperty().bind(this.menuState.getCaseInsertable().and(this.menuState.getClipboardHasCase()).not());
        menu.getItems().add(item);
        item = new MenuItem("\u65b0\u898f\u30b9\u30c6\u30c3\u30d7\u306e\u633f\u5165");
        item.setMnemonicParsing(false);
        item.setOnAction(this::newTestStep);
        item.disableProperty().bind(this.menuState.getStepInsertable().not());
        menu.getItems().add(item);
        item = new MenuItem("\u30b3\u30d4\u30fc\u3057\u305f\u30b9\u30c6\u30c3\u30d7\u306e\u633f\u5165");
        item.setMnemonicParsing(false);
        item.setOnAction(this::insertAndPasteStep);
        item.disableProperty().bind(this.menuState.getStepInsertable().and(this.menuState.getClipboardHasStep()).not());
        menu.getItems().add(item);
        menuItems.add(menu);
        menu = new Menu("\u8ffd\u52a0");
        item = new MenuItem("\u65b0\u898f\u30b9\u30c6\u30c3\u30d7\u3092\u672b\u5c3e\u306b\u8ffd\u52a0");
        item.setMnemonicParsing(false);
        item.setOnAction(this::newTestStepTail);
        menu.getItems().add(item);
        item = new MenuItem("\u65b0\u898f\u30b1\u30fc\u30b9\u3092\u672b\u5c3e\u306b\u8ffd\u52a0");
        item.setMnemonicParsing(false);
        item.setOnAction(this::newTestCaseTail);
        menu.getItems().add(item);
        item = new MenuItem("\u30b3\u30d4\u30fc\u3057\u305f\u30b1\u30fc\u30b9\u3092\u672b\u5c3e\u306b\u8ffd\u52a0");
        item.setMnemonicParsing(false);
        item.setOnAction(this::appendAndPasteCase);
        item.disableProperty().bind(this.menuState.getClipboardHasCase().not());
        menu.getItems().add(item);
        item = new MenuItem("\u30b3\u30d4\u30fc\u3057\u305f\u30b9\u30c6\u30c3\u30d7\u3092\u672b\u5c3e\u306b\u8ffd\u52a0");
        item.setMnemonicParsing(false);
        item.setOnAction(this::appendAndPasteStep);
        item.disableProperty().bind(this.menuState.getClipboardHasStep().not());
        menu.getItems().add(item);
        menuItems.add(menu);
        menu = new Menu("\u524a\u9664");
        item = new MenuItem("\u30b9\u30c6\u30c3\u30d7\u3092\u524a\u9664");
        item.setMnemonicParsing(false);
        item.setOnAction(this::deleteStep);
        item.disableProperty().bind(this.menuState.getStepSelected().not());
        menu.getItems().add(item);
        item = new MenuItem("\u30b1\u30fc\u30b9\u3092\u524a\u9664");
        item.setMnemonicParsing(false);
        item.setOnAction(this::deleteCase);
        item.disableProperty().bind(this.menuState.getCaseSelected().not());
        menu.getItems().add(item);
        menuItems.add(menu);
        menuItems.add(new SeparatorMenuItem());
        item = new MenuItem("\u30d6\u30ec\u30fc\u30af\u30dd\u30a4\u30f3\u30c8\u6709\u52b9\u5316/\u7121\u52b9\u5316");
        item.setOnAction(this::toggleBreakpoint);
        menuItems.add(item);
        return menuItems;
    }

    private boolean hasClipboardSteps() {
        return this.editor.getClipboardAccessor().hasClipboardSteps();
    }

    private boolean hasClipboardCases() {
        return this.editor.getClipboardAccessor().hasClipboardCases();
    }

    private boolean clipboardPastable() {
        return this.editor.getClipboardAccessor().clipboardPastable();
    }

    private class MenuState {
        private BooleanProperty clipboardPastable = new SimpleBooleanProperty(false);
        private BooleanProperty clipboardHasCase = new SimpleBooleanProperty(false);
        private BooleanProperty clipboardHasStep = new SimpleBooleanProperty(false);
        private BooleanProperty cellSelected = new SimpleBooleanProperty(false);
        private BooleanProperty caseSelected = new SimpleBooleanProperty(false);
        private BooleanProperty stepSelected = new SimpleBooleanProperty(false);
        private BooleanProperty caseInsertable = new SimpleBooleanProperty(false);
        private BooleanProperty stepInsertable = new SimpleBooleanProperty(false);

        private MenuState() {
        }

        @Generated
        public BooleanProperty getClipboardPastable() {
            return this.clipboardPastable;
        }

        @Generated
        public BooleanProperty getClipboardHasCase() {
            return this.clipboardHasCase;
        }

        @Generated
        public BooleanProperty getClipboardHasStep() {
            return this.clipboardHasStep;
        }

        @Generated
        public BooleanProperty getCellSelected() {
            return this.cellSelected;
        }

        @Generated
        public BooleanProperty getCaseSelected() {
            return this.caseSelected;
        }

        @Generated
        public BooleanProperty getStepSelected() {
            return this.stepSelected;
        }

        @Generated
        public BooleanProperty getCaseInsertable() {
            return this.caseInsertable;
        }

        @Generated
        public BooleanProperty getStepInsertable() {
            return this.stepInsertable;
        }
    }
}

