/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript;

import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorCell;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.InputRule;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.InputRuleProvider;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.StringUtils;

public class ScriptEditorRow {
    private static final String TEST_DATA_PROP_PREFIX = "case_";
    private Map<String, Property<ScriptEditorCell>> properties = new HashMap<String, Property<ScriptEditorCell>>();
    private InputRuleProvider ruleProvider = new InputRuleProvider();

    public static ScriptEditorRow createFromTestStep(TestStep testStep) {
        ScriptEditorRow row = new ScriptEditorRow();
        row.loadTestStep(testStep);
        return row;
    }

    private void loadTestStep(TestStep testStep) {
        this.setValue(this.noProperty(), testStep.getNo());
        this.setValue(this.itemNameProperty(), testStep.getItemName());
        this.setValue(this.operationNameProperty(), testStep.getOperationName());
        this.setValue(this.locatorTypeProperty(), testStep.getLocator().getType());
        this.setValue(this.locatorProperty(), testStep.getLocator().getValue());
        this.setValue(this.dataTypeProperty(), testStep.getDataType());
        this.setValue(this.screenshotTimingProperty(), testStep.getScreenshotTiming().getLabel());
        this.setBreakPoint(this.breakpointProperty(), testStep.isBreakPointEnabled());
        for (Map.Entry<String, String> entry : testStep.getTestData().entrySet()) {
            this.setValue(this.testDataProperty(entry.getKey()), entry.getValue());
        }
    }

    public TestStep buildTestStep(List<String> caseNoList) {
        TestStep testStep = new TestStep();
        testStep.setNo(((ScriptEditorCell)this.noProperty().getValue()).getValue());
        testStep.setItemName(((ScriptEditorCell)this.itemNameProperty().getValue()).getValue());
        testStep.setOperationName(((ScriptEditorCell)this.operationNameProperty().getValue()).getValue());
        Locator loc = new Locator();
        loc.setType(((ScriptEditorCell)this.locatorTypeProperty().getValue()).getValue());
        loc.setValue(((ScriptEditorCell)this.locatorProperty().getValue()).getValue());
        testStep.setLocator(loc);
        testStep.setDataType(((ScriptEditorCell)this.dataTypeProperty().getValue()).getValue());
        testStep.setScreenshotTiming(((ScriptEditorCell)this.screenshotTimingProperty().getValue()).getValue());
        testStep.setBreakPoint(((ScriptEditorCell)this.breakpointProperty().getValue()).isBreakpoint() ? "y" : "");
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        for (String caseNo : caseNoList) {
            data.put(caseNo, ((ScriptEditorCell)this.testDataProperty(caseNo).getValue()).getValue());
        }
        testStep.setTestData(data);
        return testStep;
    }

    public void setDebugCase(String caseNo) {
        this.removeDebugCase();
        this.setDebugCase(this.testDataProperty(caseNo), true);
    }

    public void removeDebugCase() {
        this.properties.values().forEach(tdp -> this.setDebugCase((Property<ScriptEditorCell>)tdp, false));
    }

    public void setDebugStep() {
        this.properties.values().forEach(tdp -> this.setDebugStep((Property<ScriptEditorCell>)tdp, true));
    }

    public void removeDebugStep() {
        this.properties.values().forEach(tdp -> this.setDebugStep((Property<ScriptEditorCell>)tdp, false));
    }

    public void toggleBreakpoint() {
        this.setBreakPoint(this.breakpointProperty(), !((ScriptEditorCell)this.breakpointProperty().getValue()).isBreakpoint());
    }

    private void setValue(Property<ScriptEditorCell> p, String value) {
        if (((ScriptEditorCell)p.getValue()).getInputRule().match(value)) {
            p.setValue(((ScriptEditorCell)p.getValue()).toBuilder().value(value).build());
        }
    }

    private void setInputRule(Property<ScriptEditorCell> p, InputRule rule) {
        ScriptEditorCell oldCell = (ScriptEditorCell)p.getValue();
        String newValue = rule.match(oldCell.getValue()) ? oldCell.getValue() : rule.defalutValue();
        p.setValue(oldCell.toBuilder().inputRule(rule).value(newValue).build());
    }

    private void setBreakPoint(Property<ScriptEditorCell> p, boolean breakpoint) {
        p.setValue(((ScriptEditorCell)p.getValue()).toBuilder().breakpoint(breakpoint).build());
    }

    private void setDebugStep(Property<ScriptEditorCell> p, boolean debugStep) {
        ScriptEditorCell cell = (ScriptEditorCell)p.getValue();
        if (debugStep != cell.isDebugStep()) {
            p.setValue(cell.toBuilder().debugStep(debugStep).build());
        }
    }

    private void setDebugCase(Property<ScriptEditorCell> p, boolean debugCase) {
        ScriptEditorCell cell = (ScriptEditorCell)p.getValue();
        if (debugCase != cell.isDebugCase()) {
            p.setValue(cell.toBuilder().debugCase(debugCase).build());
        }
    }

    public Property<ScriptEditorCell> noProperty() {
        return this.getProperty("no", () -> this.createBlankCell(this.ruleProvider.getNoRule()));
    }

    public Property<ScriptEditorCell> itemNameProperty() {
        return this.getProperty("itemName", () -> this.createBlankCell(this.ruleProvider.getItemNameRule()));
    }

    public Property<ScriptEditorCell> operationNameProperty() {
        return this.properties.computeIfAbsent("operationName", name -> {
            ScriptEditorCell initial = this.createBlankCell(this.ruleProvider.getOperationNameRule());
            SimpleObjectProperty<ScriptEditorCell> p = new SimpleObjectProperty<ScriptEditorCell>(this, (String)name, initial);
            p.addListener(this::onOperationNameCellChanged);
            return p;
        });
    }

    public Property<ScriptEditorCell> locatorTypeProperty() {
        return this.getProperty("locatorType", () -> this.createBlankCell(this.ruleProvider.getLocatorTypeRule(this.getOperationNameValue())));
    }

    public Property<ScriptEditorCell> locatorProperty() {
        return this.getProperty("locator", () -> this.createBlankCell(this.ruleProvider.getLocatorRule(this.getOperationNameValue())));
    }

    public Property<ScriptEditorCell> dataTypeProperty() {
        return this.getProperty("dataType", () -> this.createBlankCell(this.ruleProvider.getDataTypeRule(this.getOperationNameValue())));
    }

    public Property<ScriptEditorCell> screenshotTimingProperty() {
        return this.getProperty("screenshotTiming", () -> this.createBlankCell(this.ruleProvider.getScreenshotTimingRule()));
    }

    public Property<ScriptEditorCell> breakpointProperty() {
        return this.getProperty("breakpoint", () -> this.createBlankCell(this.ruleProvider.getBreakpointRule()));
    }

    public Property<ScriptEditorCell> testDataProperty(String caseNo) {
        return this.getProperty(TEST_DATA_PROP_PREFIX + caseNo, () -> this.createBlankCell(this.ruleProvider.getTestDataRule(this.getOperationNameValue())));
    }

    private String getOperationNameValue() {
        return ((ScriptEditorCell)this.operationNameProperty().getValue()).getValue();
    }

    private ScriptEditorCell createBlankCell(InputRule rule) {
        return ScriptEditorCell.builder().inputRule(rule).value(rule.defalutValue()).build();
    }

    private Property<ScriptEditorCell> getProperty(String name, Supplier<ScriptEditorCell> initialValueFactory) {
        return this.properties.computeIfAbsent(name, n -> new SimpleObjectProperty<ScriptEditorCell>(this, (String)n, (ScriptEditorCell)initialValueFactory.get()));
    }

    private void onOperationNameCellChanged(ObservableValue<? extends ScriptEditorCell> operationProperty, ScriptEditorCell oldOperationCell, ScriptEditorCell newOperationCell) {
        String newOperationName = newOperationCell.getValue();
        if (StringUtils.equals(oldOperationCell.getValue(), newOperationName)) {
            return;
        }
        this.setInputRule(this.locatorTypeProperty(), this.ruleProvider.getLocatorTypeRule(newOperationName));
        this.setInputRule(this.locatorProperty(), this.ruleProvider.getLocatorRule(newOperationName));
        this.setInputRule(this.dataTypeProperty(), this.ruleProvider.getDataTypeRule(newOperationName));
        for (String caseNo : this.getCaseNos()) {
            this.setInputRule(this.testDataProperty(caseNo), this.ruleProvider.getTestDataRule(newOperationName));
        }
    }

    private List<String> getCaseNos() {
        return this.properties.keySet().stream().map(name -> StringUtils.substringAfter(name, TEST_DATA_PROP_PREFIX)).filter(caseNo -> !caseNo.isEmpty()).collect(Collectors.toList());
    }
}

