/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript;

import io.sitoolkit.wt.gui.pres.editor.testscript.rule.FreeRule;
import io.sitoolkit.wt.gui.pres.editor.testscript.rule.InputRule;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public final class ScriptEditorCell {
    private final String value;
    private final InputRule inputRule;
    private final boolean debugCase;
    private final boolean debugStep;
    private final boolean breakpoint;

    public static ScriptEditorCell of(String value) {
        return ScriptEditorCell.builder().value(value).build();
    }

    public ScriptEditorCell(String value, @NonNull InputRule inputRule, boolean debugCase, boolean debugStep, boolean breakpoint) {
        if (inputRule == null) {
            throw new NullPointerException("inputRule is marked non-null but is null");
        }
        this.inputRule = inputRule;
        this.value = inputRule.convertValue(value);
        this.debugCase = debugCase;
        this.debugStep = debugStep;
        this.breakpoint = breakpoint;
    }

    public boolean isEditable() {
        return this.inputRule.isChangeable();
    }

    public boolean isChoice() {
        return this.inputRule.isChooseable();
    }

    public List<String> getChoices() {
        return this.inputRule.getChoices();
    }

    @Generated
    private static InputRule $default$inputRule() {
        return FreeRule.getInstance();
    }

    @Generated
    public static ScriptEditorCellBuilder builder() {
        return new ScriptEditorCellBuilder();
    }

    @Generated
    public ScriptEditorCellBuilder toBuilder() {
        return new ScriptEditorCellBuilder().value(this.value).inputRule(this.inputRule).debugCase(this.debugCase).debugStep(this.debugStep).breakpoint(this.breakpoint);
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public InputRule getInputRule() {
        return this.inputRule;
    }

    @Generated
    public boolean isDebugCase() {
        return this.debugCase;
    }

    @Generated
    public boolean isDebugStep() {
        return this.debugStep;
    }

    @Generated
    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptEditorCell)) {
            return false;
        }
        ScriptEditorCell other = (ScriptEditorCell)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        InputRule this$inputRule = this.getInputRule();
        InputRule other$inputRule = other.getInputRule();
        if (this$inputRule == null ? other$inputRule != null : !this$inputRule.equals(other$inputRule)) {
            return false;
        }
        if (this.isDebugCase() != other.isDebugCase()) {
            return false;
        }
        if (this.isDebugStep() != other.isDebugStep()) {
            return false;
        }
        return this.isBreakpoint() == other.isBreakpoint();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        InputRule $inputRule = this.getInputRule();
        result = result * 59 + ($inputRule == null ? 43 : $inputRule.hashCode());
        result = result * 59 + (this.isDebugCase() ? 79 : 97);
        result = result * 59 + (this.isDebugStep() ? 79 : 97);
        result = result * 59 + (this.isBreakpoint() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "ScriptEditorCell(value=" + this.getValue() + ", inputRule=" + this.getInputRule() + ", debugCase=" + this.isDebugCase() + ", debugStep=" + this.isDebugStep() + ", breakpoint=" + this.isBreakpoint() + ")";
    }

    @Generated
    public static class ScriptEditorCellBuilder {
        @Generated
        private String value;
        @Generated
        private boolean inputRule$set;
        @Generated
        private InputRule inputRule;
        @Generated
        private boolean debugCase;
        @Generated
        private boolean debugStep;
        @Generated
        private boolean breakpoint;

        @Generated
        ScriptEditorCellBuilder() {
        }

        @Generated
        public ScriptEditorCellBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public ScriptEditorCellBuilder inputRule(InputRule inputRule) {
            this.inputRule = inputRule;
            this.inputRule$set = true;
            return this;
        }

        @Generated
        public ScriptEditorCellBuilder debugCase(boolean debugCase) {
            this.debugCase = debugCase;
            return this;
        }

        @Generated
        public ScriptEditorCellBuilder debugStep(boolean debugStep) {
            this.debugStep = debugStep;
            return this;
        }

        @Generated
        public ScriptEditorCellBuilder breakpoint(boolean breakpoint) {
            this.breakpoint = breakpoint;
            return this;
        }

        @Generated
        public ScriptEditorCell build() {
            InputRule inputRule = this.inputRule;
            if (!this.inputRule$set) {
                inputRule = ScriptEditorCell.$default$inputRule();
            }
            return new ScriptEditorCell(this.value, inputRule, this.debugCase, this.debugStep, this.breakpoint);
        }

        @Generated
        public String toString() {
            return "ScriptEditorCell.ScriptEditorCellBuilder(value=" + this.value + ", inputRule=" + this.inputRule + ", debugCase=" + this.debugCase + ", debugStep=" + this.debugStep + ", breakpoint=" + this.breakpoint + ")";
        }
    }
}

