/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres.editor.testscript;

import io.sitoolkit.wt.gui.pres.editor.testscript.ClipboardScriptAccessor;
import io.sitoolkit.wt.gui.pres.editor.testscript.ScriptEditorRow;
import io.sitoolkit.wt.gui.pres.editor.testscript.TestScriptEditorFxImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ClipboardScriptAccessorFxImpl
implements ClipboardScriptAccessor {
    private static final String MINE_TYPE_CELL = "io.sitoolkit.wt.testscript.cell";
    private static final DataFormat DATAFORMAT_CELL;
    TestScriptEditorFxImpl editor;

    public ClipboardScriptAccessorFxImpl(TestScriptEditorFxImpl editor) {
        this.editor = editor;
    }

    @Override
    public int getClipboardCaseCount() {
        return this.countCases(this.readFromClipboard());
    }

    @Override
    public int getClipboardStepCount() {
        return this.countSteps(this.readFromClipboard());
    }

    @Override
    public boolean hasClipboardCases() {
        return this.getClipboardCaseCount() > 0;
    }

    @Override
    public boolean hasClipboardSteps() {
        return this.getClipboardStepCount() > 0;
    }

    private int countCases(List<Cell> changeList) {
        int columnCount = this.countColumns(changeList);
        int rowCount = this.countRows(changeList);
        return this.editor.getRowCount() == rowCount ? columnCount : 0;
    }

    private int countSteps(List<Cell> changeList) {
        int columnCount = this.countColumns(changeList);
        int rowCount = this.countRows(changeList);
        return this.editor.getColumnCount() == columnCount ? rowCount : 0;
    }

    private int countColumns(List<Cell> changeList) {
        Set<Integer> colSet = changeList.stream().map(change -> change.getColumn()).collect(Collectors.toSet());
        return this.countMinToMax(colSet);
    }

    private int countRows(List<Cell> changeList) {
        Set<Integer> rowSet = changeList.stream().map(change -> change.getRow()).collect(Collectors.toSet());
        return this.countMinToMax(rowSet);
    }

    private int countMinToMax(Collection<Integer> values) {
        return values.isEmpty() ? 0 : values.stream().max(Comparator.naturalOrder()).get() - values.stream().min(Comparator.naturalOrder()).get() + 1;
    }

    @Override
    public boolean clipboardPastable() {
        return this.readFromClipboard().size() > 0 && this.editor.getSelection().getSelectedCells().size() == 1;
    }

    @Override
    public void copy() {
        TableView.TableViewSelectionModel<ScriptEditorRow> selection = this.editor.getSelection();
        ObservableList<TablePosition> posList = selection.getSelectedCells();
        if (posList.isEmpty()) {
            return;
        }
        int leftColumn = posList.stream().mapToInt(TablePosition::getColumn).min().getAsInt();
        int topRow = posList.stream().mapToInt(TablePositionBase::getRow).min().getAsInt();
        List<Cell> selectedCells = posList.stream().map(p -> this.createDataFromEditor((TablePosition<?, ?>)p, topRow, leftColumn)).collect(Collectors.toList());
        this.writeToClipboard(selectedCells);
    }

    @Override
    public void paste() {
        if (!this.clipboardPastable()) {
            return;
        }
        TablePosition position = (TablePosition)this.editor.getSelection().getSelectedCells().get(0);
        this.readFromClipboard().stream().forEach(cell -> this.writeToEditor(position, (Cell)cell));
    }

    private Cell createDataFromEditor(TablePosition<?, ?> position, int topRow, int leftColumn) {
        return new Cell(position.getRow() - topRow, position.getColumn() - leftColumn, this.editor.getCellValue(position.getRow(), position.getColumn()));
    }

    private void writeToEditor(TablePosition<?, ?> position, Cell cell) {
        this.editor.setCellValue(position.getRow() + cell.getRow(), position.getColumn() + cell.getColumn(), cell.getValue());
    }

    private List<Cell> readFromClipboard() {
        List<Cell> cells = (List<Cell>)Clipboard.getSystemClipboard().getContent(DATAFORMAT_CELL);
        return cells != null ? cells : Collections.emptyList();
    }

    private void writeToClipboard(List<Cell> cells) {
        ClipboardContent content = new ClipboardContent();
        content.put(DATAFORMAT_CELL, cells);
        content.putString(this.toTsvString(cells));
        Clipboard.getSystemClipboard().setContent(content);
    }

    private String toTsvString(List<Cell> cells) {
        String[][] grid = this.createGrid(cells);
        return Stream.of(grid).map(row -> Stream.of(row).map(StringUtils::defaultString).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
    }

    private String[][] createGrid(List<Cell> cells) {
        int row = cells.stream().mapToInt(Cell::getRow).max().getAsInt();
        int column = cells.stream().mapToInt(Cell::getColumn).max().getAsInt();
        String[][] grid = new String[row + 1][column + 1];
        cells.forEach(c -> {
            grid[c.getRow()][c.getColumn()] = c.getValue();
        });
        return grid;
    }

    static {
        DataFormat fmt = DataFormat.lookupMimeType(MINE_TYPE_CELL);
        if (fmt == null) {
            fmt = new DataFormat(MINE_TYPE_CELL);
        }
        DATAFORMAT_CELL = fmt;
    }

    static final class Cell
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int row;
        private final int column;
        private final String value;

        @Generated
        public Cell(int row, int column, String value) {
            this.row = row;
            this.column = column;
            this.value = value;
        }

        @Generated
        public int getRow() {
            return this.row;
        }

        @Generated
        public int getColumn() {
            return this.column;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)o;
            if (this.getRow() != other.getRow()) {
                return false;
            }
            if (this.getColumn() != other.getColumn()) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRow();
            result = result * 59 + this.getColumn();
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClipboardScriptAccessorFxImpl.Cell(row=" + this.getRow() + ", column=" + this.getColumn() + ", value=" + this.getValue() + ")";
        }
    }
}

