/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.gui.app.update.UpdateService;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class UpdateController {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(UpdateController.class);
    UpdateService service;
    String projectBase;

    public UpdateController(String projectBase) {
        this.projectBase = projectBase;
        this.service = new UpdateService(projectBase);
    }

    public void checkAndInstall() {
        try {
            File pomFile = this.unarchivePom();
            this.service.checkSitWtAppUpdate(pomFile, this::confirmAndInstall);
        }
        catch (IOException e) {
            LOG.warn("app.pomUnarchiveFailed", e);
        }
    }

    private File unarchivePom() throws IOException {
        URL url = ClassLoader.getSystemResource("META-INF/maven/io.sitoolkit.wt/sit-wt-app/pom.xml");
        File pom = new File(this.projectBase, "sit-wt-app-pom-" + System.currentTimeMillis() + ".xml");
        Files.copy(url.openStream(), pom.toPath(), new CopyOption[0]);
        pom.deleteOnExit();
        return pom;
    }

    private void confirmAndInstall(String newVersion) {
        Platform.runLater(() -> {
            Alert conf = new Alert(Alert.AlertType.CONFIRMATION);
            conf.setContentText("SIT-WT\u306e\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u3042\u308a\u307e\u3059\u3002\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3059\u304b\uff1f");
            Optional result = conf.showAndWait();
            if (result.get() == ButtonType.OK) {
                this.service.downloadSitWtApp(new File("."), newVersion, this::restart);
            }
        });
    }

    private void restart(File jar) {
        Platform.runLater(() -> {
            Alert conf = new Alert(Alert.AlertType.CONFIRMATION);
            conf.setContentText("\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306f\u518d\u8d77\u52d5\u5f8c\u306b\u6709\u52b9\u306b\u306a\u308a\u307e\u3059\u3002\u518d\u8d77\u52d5\u3057\u307e\u3059\u304b\uff1f");
            Optional result = conf.showAndWait();
            if (result.get() == ButtonType.OK) {
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command("java", "-jar", jar.getAbsolutePath());
                LOG.info("app.execute", builder.command());
                try {
                    builder.start();
                    Platform.exit();
                }
                catch (IOException e) {
                    LOG.error("app.restartFailed", e);
                }
            }
        });
    }
}

