/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.gui.pres.TestRunnable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.util.Callback;

public class TestCaseDialogController
implements Initializable {
    @FXML
    private Label testScriptLabel;
    @FXML
    private FlowPane caseNoFlowPane;
    @FXML
    private Node content;
    TestRunnable testRunnable;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
    }

    public void showSelectDialog(File currentFile, List<String> caseIdList) {
        this.showDialog(currentFile, caseIdList, false);
    }

    public void showSelectDebugDialog(File currentFile, List<String> caseIdList) {
        this.showDialog(currentFile, caseIdList, true);
    }

    public void setTestRunnable(TestRunnable testRunnable) {
        this.testRunnable = testRunnable;
    }

    private void showDialog(File currentFile, List<String> caseIdList, boolean isDebug) {
        this.caseNoFlowPane.getChildren().clear();
        Dialog<List<String>> dialog = new Dialog<List<String>>();
        dialog.setTitle("\u30b1\u30fc\u30b9\u3092\u6307\u5b9a\u3057\u3066\u5b9f\u884c");
        dialog.setHeaderText("\u5b9f\u884c\u3059\u308b\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.testScriptLabel.setText(currentFile.getName());
        CheckBoxResultConverter resultConverter = new CheckBoxResultConverter();
        dialog.setResultConverter(resultConverter);
        for (String caseId : caseIdList) {
            CheckBox checkBox = new CheckBox(caseId);
            resultConverter.add(checkBox);
            this.caseNoFlowPane.getChildren().add(checkBox);
        }
        dialog.getDialogPane().setContent(this.content);
        Optional result = dialog.showAndWait();
        result.ifPresent(selectedCaseNos -> {
            if (!selectedCaseNos.isEmpty()) {
                this.testRunnable.runTest(isDebug, false, currentFile, (List<String>)selectedCaseNos);
            }
        });
    }

    class CheckBoxResultConverter
    implements Callback<ButtonType, List<String>> {
        List<CheckBox> checkBoxes = new ArrayList<CheckBox>();

        CheckBoxResultConverter() {
        }

        void add(CheckBox checkbox) {
            this.checkBoxes.add(checkbox);
        }

        @Override
        public List<String> call(ButtonType buttonType) {
            ArrayList<String> selected = new ArrayList<String>();
            if (buttonType == ButtonType.OK) {
                for (CheckBox checkBox : this.checkBoxes) {
                    if (!checkBox.isSelected()) continue;
                    selected.add(checkBox.getText());
                }
            }
            return selected;
        }
    }
}

