/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.gui.domain.project.ProjectState;
import io.sitoolkit.wt.gui.infra.fx.FxContext;
import io.sitoolkit.wt.gui.infra.fx.ScriptDialog;
import io.sitoolkit.wt.gui.pres.AppController;
import io.sitoolkit.wt.gui.pres.DiffEvidenceToolbarController;
import io.sitoolkit.wt.gui.pres.EditorTabController;
import io.sitoolkit.wt.gui.pres.SampleToolbarController;
import io.sitoolkit.wt.gui.pres.TestToolbarController;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.MenuItem;
import lombok.Generated;

public class MenuBarController
implements Initializable {
    @FXML
    MenuItem saveMenu;
    @FXML
    MenuItem saveAsMenu;
    @FXML
    MenuItem runMenu;
    @FXML
    MenuItem debugMenu;
    @FXML
    MenuItem runParallelMenu;
    @FXML
    MenuItem quitMenu;
    @FXML
    MenuItem pauseMenu;
    @FXML
    MenuItem restartMenu;
    @FXML
    MenuItem backMenu;
    @FXML
    MenuItem forwardMenu;
    @FXML
    MenuItem maskEvidenceMenu;
    @FXML
    MenuItem setBaseEvidenceMenu;
    @FXML
    MenuItem genDiffEvidenceMenu;
    @FXML
    MenuItem ope2scriptMenu;
    @FXML
    MenuItem quitOperatingMenu;
    @FXML
    MenuItem page2scriptMenu;
    @FXML
    MenuItem exportMenu;
    @FXML
    MenuItem quitBrowsingMenu;
    @FXML
    MenuItem runSampleMenu;
    @FXML
    MenuItem stopSampleMenu;
    AppController appController;
    private EditorTabController editorTabController;
    TestToolbarController testToolbarController;
    DiffEvidenceToolbarController diffEvidenceToolbarController;
    SampleToolbarController sampleToolbarController;
    ProjectState projectState;
    private ScriptDialog scriptDialog = new ScriptDialog();

    @Override
    public void initialize(URL location, ResourceBundle resources) {
    }

    public void initialize() {
        this.saveMenu.disableProperty().bind(this.editorTabController.getEmpty());
        this.saveAsMenu.disableProperty().bind(this.editorTabController.getEmpty());
        this.runMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.debugMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.runParallelMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.quitMenu.visibleProperty().bind(this.projectState.isRunning());
        this.pauseMenu.visibleProperty().bind(this.projectState.isDebugging().and(this.testToolbarController.getPausing().not()));
        this.restartMenu.visibleProperty().bind(this.projectState.isDebugging().and(this.testToolbarController.getPausing()));
        this.backMenu.visibleProperty().bind(this.projectState.isDebugging());
        this.forwardMenu.visibleProperty().bind(this.projectState.isDebugging());
        this.maskEvidenceMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.setBaseEvidenceMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.genDiffEvidenceMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.ope2scriptMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.page2scriptMenu.visibleProperty().bind(this.projectState.isLoaded());
        this.exportMenu.visibleProperty().bind(this.projectState.isBrowsing());
        this.quitBrowsingMenu.visibleProperty().bind(this.projectState.isBrowsing());
        this.quitOperatingMenu.visibleProperty().bind(this.projectState.isOperating());
        this.runSampleMenu.visibleProperty().bind(this.sampleToolbarController.getRunning().not().and(this.projectState.isLoaded()));
        this.stopSampleMenu.visibleProperty().bind(this.sampleToolbarController.getRunning().and(this.projectState.isLoaded()));
    }

    @FXML
    public void openProject() {
        this.appController.openProject();
    }

    @FXML
    public void open() {
        File file = this.scriptDialog.showOpenDialog(FxContext.getPrimaryStage());
        if (file != null) {
            this.editorTabController.open(file.toPath());
        }
    }

    @FXML
    public void save() {
        this.editorTabController.save();
    }

    @FXML
    public void saveAs() {
        File file = this.scriptDialog.showSaveDialog(FxContext.getPrimaryStage());
        if (file != null) {
            this.editorTabController.saveAs(file.toPath());
        }
    }

    @FXML
    public void run() {
        this.testToolbarController.run();
    }

    @FXML
    public void debug() {
        this.testToolbarController.debug();
    }

    @FXML
    public void runParallel() {
        this.testToolbarController.runParallel();
    }

    @FXML
    public void quit() {
        this.testToolbarController.quit();
    }

    @FXML
    public void pause() {
        this.testToolbarController.pause();
    }

    @FXML
    public void restart() {
        this.testToolbarController.restart();
    }

    @FXML
    public void back() {
        this.testToolbarController.back();
    }

    @FXML
    public void forward() {
        this.testToolbarController.forward();
    }

    @FXML
    public void maskEvidence() {
        this.diffEvidenceToolbarController.maskEvidence();
    }

    @FXML
    public void setBaseEvidence() {
        this.diffEvidenceToolbarController.setBaseEvidence();
    }

    @FXML
    public void genDiffEvidence() {
        this.diffEvidenceToolbarController.genDiffEvidence();
    }

    @FXML
    public void ope2script() {
        this.appController.ope2script();
    }

    @FXML
    public void quitOperating() {
        this.appController.quitOperating();
    }

    @FXML
    public void page2script() {
        this.appController.page2script();
    }

    @FXML
    public void export() {
        this.appController.export();
    }

    @FXML
    public void quitBrowsing() {
        this.appController.quitBrowsing();
    }

    @FXML
    public void runSample() {
        this.sampleToolbarController.runSample();
    }

    @FXML
    public void stopSample() {
        this.sampleToolbarController.stopSample();
    }

    @FXML
    public void settings() {
        this.appController.settings();
    }

    @FXML
    public void help() {
        this.appController.help();
    }

    @Generated
    public void setAppController(AppController appController) {
        this.appController = appController;
    }

    @Generated
    public void setEditorTabController(EditorTabController editorTabController) {
        this.editorTabController = editorTabController;
    }

    @Generated
    public void setTestToolbarController(TestToolbarController testToolbarController) {
        this.testToolbarController = testToolbarController;
    }

    @Generated
    public void setDiffEvidenceToolbarController(DiffEvidenceToolbarController diffEvidenceToolbarController) {
        this.diffEvidenceToolbarController = diffEvidenceToolbarController;
    }

    @Generated
    public void setSampleToolbarController(SampleToolbarController sampleToolbarController) {
        this.sampleToolbarController = sampleToolbarController;
    }

    @Generated
    public void setProjectState(ProjectState projectState) {
        this.projectState = projectState;
    }
}

