/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.wt.gui.app.script.ScriptService;
import io.sitoolkit.wt.gui.infra.fx.FileSystemWatchService;
import io.sitoolkit.wt.gui.infra.fx.FileTreeItem;
import io.sitoolkit.wt.gui.infra.fx.FileWrapper;
import io.sitoolkit.wt.gui.pres.FileOpenable;
import io.sitoolkit.wt.gui.pres.TestCaseDialogController;
import io.sitoolkit.wt.gui.pres.TestRunnable;
import io.sitoolkit.wt.util.infra.util.StrUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.input.MouseButton;
import javax.annotation.Resource;

public class FileTreeController
implements Initializable {
    @FXML
    private TreeView<FileWrapper> fileTree;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private MenuItem executeMenuItem;
    @FXML
    private MenuItem executeCaseMenuItem;
    @FXML
    private MenuItem executeDebugCaseMenuItem;
    private Mode mode = Mode.NORMAL;
    FileSystemWatchService fileSystemWatchService = new FileSystemWatchService();
    TestRunnable testRunnable;
    FileOpenable fileOpenable;
    @Resource
    ScriptService scriptService;
    TestCaseDialogController testCaseDialogController;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.fileTree.setOnMouseClicked(mouseEvent -> {
            if (MouseButton.PRIMARY.equals((Object)mouseEvent.getButton()) && mouseEvent.getClickCount() > 1) {
                this.fileOpenable.open(this.getSelectedItem());
            }
        });
        this.fileTree.setEditable(true);
        this.fileTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        if (this.mode == Mode.CHECKBOX) {
            this.fileTree.setCellFactory(CheckBoxTreeCell.forTreeView());
        }
        this.fileTree.setShowRoot(false);
        this.contextMenu.setOnShowing(value -> this.operateSelectedItem(selectedItem -> {
            String selectedFileName = ((FileWrapper)selectedItem.getValue()).getFile().getName();
            this.executeMenuItem.setVisible(StrUtils.endsWithAny(selectedFileName, ".csv"));
            this.executeCaseMenuItem.setVisible(StrUtils.endsWithAny(selectedFileName, ".csv"));
            this.executeDebugCaseMenuItem.setVisible(StrUtils.endsWithAny(selectedFileName, ".csv"));
        }));
        this.fileSystemWatchService.init();
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/TestCaseDialog.fxml"));
        try {
            loader.load();
            this.testCaseDialogController = (TestCaseDialogController)loader.getController();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.fileSystemWatchService.destroy();
    }

    public File getRoot() {
        return this.fileTree.getRoot().getValue().getFile();
    }

    public void setFileTreeRoot(File baseDir) {
        TreeItem<FileWrapper> root = new TreeItem<FileWrapper>();
        root.setValue(new FileWrapper(baseDir));
        FileTreeItem pagescriptItem = new FileTreeItem(this.newDir(baseDir, "pagescript"));
        pagescriptItem.buildChildren();
        root.getChildren().add(pagescriptItem);
        FileTreeItem testscriptItem = new FileTreeItem(this.newDir(baseDir, "testscript"));
        testscriptItem.buildChildren();
        root.getChildren().add(testscriptItem);
        FileTreeItem baseEvidenceItem = new FileTreeItem(this.newDir(baseDir, "base-evidence"));
        baseEvidenceItem.buildChildren();
        root.getChildren().add(baseEvidenceItem);
        FileTreeItem evidenceItem = new FileTreeItem(this.newDir(baseDir, "evidence"));
        evidenceItem.buildChildren();
        root.getChildren().add(evidenceItem);
        this.fileTree.setRoot(root);
        this.fileSystemWatchService.register(pagescriptItem);
        this.fileSystemWatchService.register(testscriptItem);
        this.fileSystemWatchService.register(baseEvidenceItem);
        this.fileSystemWatchService.register(evidenceItem);
    }

    private File newDir(File baseDir, String dir) {
        File newDir = new File(baseDir, dir);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        return newDir;
    }

    public List<File> getSelectedItems(boolean recursive) {
        return this.tree2files(this.fileTree.getSelectionModel().getSelectedItems(), recursive);
    }

    public File getSelectedItem() {
        TreeItem selectedItem = (TreeItem)this.fileTree.getSelectionModel().getSelectedItem();
        return selectedItem == null ? null : ((FileWrapper)selectedItem.getValue()).getFile();
    }

    private List<File> tree2files(List<?> fileTree, boolean recursive) {
        ArrayList<File> allFiles = new ArrayList<File>();
        for (Object item : fileTree) {
            if (!(item instanceof FileTreeItem)) continue;
            FileTreeItem casted = (FileTreeItem)item;
            File target = ((FileWrapper)casted.getValue()).getFile();
            if (recursive && target.isDirectory()) {
                allFiles.addAll(this.tree2files(casted.getChildren(), recursive));
                continue;
            }
            allFiles.add(target);
        }
        return allFiles;
    }

    @FXML
    public void open() {
        this.operateSelectedItem(selectedItem -> this.fileOpenable.open(((FileWrapper)selectedItem.getValue()).getFile()));
    }

    @FXML
    public void newFolder() {
        this.operateSelectedDir(selectedItem -> {
            TextInputDialog dialog = new TextInputDialog("\u65b0\u3057\u3044\u30d5\u30a9\u30eb\u30c0\u30fc");
            dialog.setTitle("\u65b0\u898f\u30d5\u30a9\u30eb\u30c0\u30fc");
            dialog.setHeaderText("\u30d5\u30a9\u30eb\u30c0\u30fc\u306e\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            Optional result = dialog.showAndWait();
            result.ifPresent(name -> {
                File newDir = new File(((FileWrapper)selectedItem.getValue()).getFile(), (String)name);
                if (newDir.exists()) {
                    return;
                }
                newDir.mkdir();
            });
        });
    }

    @FXML
    public void newScript() {
        this.operateSelectedDir(selectedItem -> {
            TextInputDialog dialog = new TextInputDialog("NewTestScript.csv");
            dialog.setTitle("\u65b0\u898f\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8");
            dialog.setHeaderText("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            Optional result = dialog.showAndWait();
            result.ifPresent(name -> {
                name = ((String)name).endsWith(".csv") ? name : (String)name + ".csv";
                Path newTestScript = ((FileWrapper)selectedItem.getValue()).getFile().toPath().resolve((String)name);
                if (newTestScript.toFile().exists()) {
                    return;
                }
                this.scriptService.generateNewScript(newTestScript);
            });
        });
    }

    @FXML
    public void rename() {
        this.operateSelectedItem(selectedItem -> {
            File currentFile = ((FileWrapper)selectedItem.getValue()).getFile();
            TextInputDialog dialog = new TextInputDialog(currentFile.getName());
            dialog.setTitle("\u540d\u79f0\u5909\u66f4");
            dialog.setHeaderText("\u65b0\u3057\u3044\u540d\u524d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            Optional result = dialog.showAndWait();
            result.ifPresent(name -> {
                File newFile = new File(currentFile.getParent(), (String)name);
                if (newFile.exists()) {
                    return;
                }
                currentFile.renameTo(newFile);
            });
        });
    }

    @FXML
    public void delete() {
        TreeItem selectedItem = (TreeItem)this.fileTree.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        ((FileWrapper)selectedItem.getValue()).getFile().delete();
        selectedItem.getParent().getChildren().remove(selectedItem);
    }

    @FXML
    public void execute() {
        this.testRunnable.run();
    }

    @FXML
    public void executeCase() {
        this.operateSelectedItem(selectedItem -> {
            File selectedFile = ((FileWrapper)selectedItem.getValue()).getFile();
            List<String> caseNos = this.scriptService.readCaseNo(selectedFile);
            this.testCaseDialogController.showSelectDebugDialog(selectedFile, caseNos);
        });
    }

    @FXML
    public void executeDebugCase() {
        this.operateSelectedItem(selectedItem -> {
            File selectedFile = ((FileWrapper)selectedItem.getValue()).getFile();
            List<String> caseNos = this.scriptService.readCaseNo(selectedFile);
            this.testCaseDialogController.showSelectDebugDialog(selectedFile, caseNos);
        });
    }

    private void operateSelectedItem(Operation operation) {
        TreeItem selectedItem = (TreeItem)this.fileTree.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        operation.operate(selectedItem);
    }

    private void operateSelectedDir(Operation operation) {
        this.operateSelectedItem(selectedItem -> {
            File dir = ((FileWrapper)selectedItem.getValue()).getFile();
            if (dir.isFile()) {
                dir = dir.getParentFile();
                selectedItem = selectedItem.getParent();
            }
            operation.operate(selectedItem);
        });
    }

    public void setTestRunnable(TestRunnable testRunnable) {
        this.testRunnable = testRunnable;
        this.testCaseDialogController.setTestRunnable(testRunnable);
    }

    public void showAlert(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("");
        alert.setContentText("");
        alert.setHeaderText(message);
        alert.show();
    }

    static enum Mode {
        NORMAL,
        CHECKBOX;

    }

    @FunctionalInterface
    static interface Operation {
        public void operate(TreeItem<FileWrapper> var1);
    }
}

