/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.pres;

import io.sitoolkit.util.buildtoolhelper.process.StdoutListenerContainer;
import io.sitoolkit.wt.gui.app.diffevidence.DiffEvidenceService;
import io.sitoolkit.wt.gui.app.project.ProjectService;
import io.sitoolkit.wt.gui.app.script.ScriptService;
import io.sitoolkit.wt.gui.app.test.TestService;
import io.sitoolkit.wt.gui.domain.project.ProjectState;
import io.sitoolkit.wt.gui.infra.fx.FxContext;
import io.sitoolkit.wt.gui.infra.fx.FxUtils;
import io.sitoolkit.wt.gui.infra.log.TextAreaOutputStream;
import io.sitoolkit.wt.gui.infra.process.TextAreaStdoutListener;
import io.sitoolkit.wt.gui.pres.DiffEvidenceToolbarController;
import io.sitoolkit.wt.gui.pres.EditorTabController;
import io.sitoolkit.wt.gui.pres.FileTreeController;
import io.sitoolkit.wt.gui.pres.MenuBarController;
import io.sitoolkit.wt.gui.pres.MessageView;
import io.sitoolkit.wt.gui.pres.SampleToolbarController;
import io.sitoolkit.wt.gui.pres.TestToolbarController;
import io.sitoolkit.wt.gui.pres.UpdateController;
import io.sitoolkit.wt.infra.log.DelegatingOutputStreamAppender;
import io.sitoolkit.wt.util.infra.concurrent.ExecutorContainer;
import io.sitoolkit.wt.util.infra.process.ConversationProcess;
import io.sitoolkit.wt.util.infra.process.ConversationProcessContainer;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.HBox;
import javafx.stage.DirectoryChooser;
import javax.annotation.Resource;

public class AppController
implements Initializable {
    @FXML
    private HBox projectGroup;
    @FXML
    private ToolBar genScriptGroup;
    @FXML
    private ToolBar browsingGroup;
    @FXML
    private ToolBar operatingGroup;
    @FXML
    private TextArea console;
    @FXML
    private Label exportButton;
    @FXML
    private Label toggleButton;
    @FXML
    private Label openButton;
    @FXML
    private Label saveButton;
    @FXML
    private Label saveAsButton;
    @FXML
    private SampleToolbarController sampleToolbarController;
    @FXML
    private FileTreeController fileTreeController;
    @FXML
    private TestToolbarController testToolbarController;
    @FXML
    private DiffEvidenceToolbarController diffEvidenceToolbarController;
    @FXML
    private MenuItem sampleRunMenu;
    @FXML
    private MenuItem sampleStopMenu;
    @FXML
    private TabPane editorTab;
    @FXML
    private MenuBarController menuBarController;
    private MessageView messageView = new MessageView();
    private ConversationProcess conversationProcess;
    private ProjectState projectState = new ProjectState();
    UpdateController updateController;
    EditorTabController editorTabController = new EditorTabController();
    DiffEvidenceService diffEvidenceService = new DiffEvidenceService();
    TestService testService = new TestService();
    ProjectService projectService = new ProjectService();
    @Resource
    ScriptService scriptService;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        DelegatingOutputStreamAppender.setStaticOutputStream(new TextAreaOutputStream(this.console));
        FxUtils.bindVisible(this.projectGroup, this.projectState.isLocking().not());
        FxUtils.bindVisible(this.genScriptGroup, this.projectState.isLoaded());
        FxUtils.bindVisible(this.browsingGroup, this.projectState.isBrowsing());
        FxUtils.bindVisible(this.operatingGroup, this.projectState.isOperating());
        this.messageView.setTextArea(this.console);
        StdoutListenerContainer.getInstance().getStdoutListeners().add(new TextAreaStdoutListener(this.console));
        StdoutListenerContainer.getInstance().getStderrListeners().add(new TextAreaStdoutListener(this.console));
        this.testToolbarController.initialize(this.messageView, this.fileTreeController, this.projectState, this.editorTabController, this.editorTabController, this.editorTabController);
        this.testToolbarController.testService = this.testService;
        this.sampleToolbarController.initialize(this.messageView, this.testToolbarController, this.projectState);
        this.diffEvidenceToolbarController.initialize(this.messageView, this.fileTreeController, this.projectState);
        this.fileTreeController.setTestRunnable(this.testToolbarController);
        this.fileTreeController.fileOpenable = this.editorTabController;
        this.editorTabController.setTabs(this.editorTab);
        this.editorTabController.setScriptService(this.scriptService);
        this.editorTabController.initialize();
        FxUtils.bindDisable(this.saveButton, this.editorTabController.getEmpty());
        FxUtils.bindDisable(this.saveAsButton, this.editorTabController.getEmpty());
        this.menuBarController.setProjectState(this.projectState);
        this.menuBarController.setAppController(this);
        this.menuBarController.setEditorTabController(this.editorTabController);
        this.menuBarController.setTestToolbarController(this.testToolbarController);
        this.menuBarController.setDiffEvidenceToolbarController(this.diffEvidenceToolbarController);
        this.menuBarController.setSampleToolbarController(this.sampleToolbarController);
        this.menuBarController.initialize();
    }

    public void postInit() {
        File pomFile = this.projectService.openProject(new File(""), this.projectState);
        if (pomFile == null) {
            this.openProject();
        } else {
            this.loadProject(pomFile);
        }
    }

    public void destroy() {
        ConversationProcessContainer.destroy();
        this.testToolbarController.destroy();
        this.fileTreeController.destroy();
        this.sampleToolbarController.destroy();
    }

    @FXML
    public void openProject() {
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        dirChooser.setInitialDirectory(new File("."));
        File projectDir = dirChooser.showDialog(FxContext.getPrimaryStage());
        if (projectDir == null) {
            return;
        }
        File pomFile = this.projectService.openProject(projectDir, this.projectState);
        if (pomFile == null) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setContentText(projectDir.getAbsolutePath() + "\u306b\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059\u304b\uff1f");
            Optional answer = alert.showAndWait();
            if (answer.orElse(null) == ButtonType.OK) {
                pomFile = this.projectService.createProject(projectDir, this.projectState);
                this.loadProject(pomFile);
            }
        } else {
            this.loadProject(pomFile);
        }
        this.updateController = new UpdateController(projectDir.getAbsolutePath());
        if (!Boolean.getBoolean("skipUpdate")) {
            ExecutorContainer.get().execute(() -> this.updateController.checkAndInstall());
        }
        System.setProperty("sitwt.projectDirectory", projectDir.getAbsolutePath());
    }

    private void loadProject(File pomFile) {
        File projectDir = pomFile.getAbsoluteFile().getParentFile();
        this.messageView.addMsg("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u958b\u304d\u307e\u3059\u3002" + projectDir.getAbsolutePath());
        this.fileTreeController.setFileTreeRoot(projectDir);
        this.testToolbarController.loadProject();
        this.scriptService.loadProject();
        FxContext.setTitie(projectDir.getAbsolutePath());
    }

    @FXML
    public void editScript() {
        this.menuBarController.open();
    }

    @FXML
    public void editor2script() {
        this.menuBarController.save();
    }

    @FXML
    public void editor2scriptAs() {
        this.menuBarController.saveAs();
    }

    @FXML
    public void page2script() {
        this.messageView.startMsg("\u30d6\u30e9\u30a6\u30b6\u3067\u30da\u30fc\u30b8\u3092\u8868\u793a\u3057\u305f\u72b6\u614b\u3067\u300c\u30b9\u30af\u30ea\u30d7\u30c8\u751f\u6210\u300d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.projectState.setState(ProjectState.State.BROWSING);
        this.scriptService.page2script(this.testToolbarController.getDriverType(), this.testToolbarController.getBaseUrl());
    }

    @FXML
    public void quitBrowsing() {
        this.scriptService.quitBrowsing();
        this.projectState.reset();
    }

    @FXML
    public void ope2script() {
        this.messageView.startMsg("\u30d6\u30e9\u30a6\u30b6\u64cd\u4f5c\u306e\u8a18\u9332\u306fChromium\u3068Selenium IDE Plugin\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
        this.messageView.addMsg("Selenium IDE\u3067\u8a18\u9332\u3057\u305f\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092html\u5f62\u5f0f\u3067testscript\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u4fdd\u5b58\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.projectState.setState(ProjectState.State.OPERATING);
        this.scriptService.ope2script(this.testToolbarController.getBaseUrl());
    }

    @FXML
    public void quitOperating() {
        this.scriptService.quitOperating();
        this.projectState.reset();
    }

    @FXML
    public void export() {
        Path exportScript = this.scriptService.export();
        this.editorTabController.open(exportScript);
    }

    @FXML
    public void openScript() {
        this.conversationProcess.input("o");
    }

    @FXML
    public void quit() {
        this.conversationProcess.destroy();
        this.projectState.reset();
    }

    @FXML
    public void settings() {
        FxContext.openFile(new File(this.projectState.getBaseDir(), "src/main/resources"));
    }

    @FXML
    public void help() {
        FxContext.showDocument("https://github.com/sitoolkit/sit-wt-all/wiki");
    }
}

