/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.domain.script;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CaseNoCache {
    private Map<String, TestScript> cache = new HashMap<String, TestScript>();

    public void putCaesNos(File testScript, List<String> caseNos) {
        this.cache.put(this.toCacheKey(testScript), new TestScript(testScript, caseNos));
    }

    public List<String> getCaseNosIfNotModified(File testScript) {
        String key = this.toCacheKey(testScript);
        TestScript cachedTestScript = this.cache.get(key);
        if (cachedTestScript == null) {
            return null;
        }
        if (key.equals(this.toCacheKey(cachedTestScript))) {
            return cachedTestScript.caseNos;
        }
        return null;
    }

    private String toCacheKey(File file) {
        return file.getAbsolutePath() + ";" + file.lastModified();
    }

    private String toCacheKey(TestScript script) {
        return script.path + ";" + script.lastModified;
    }

    class TestScript {
        String path;
        long lastModified;
        List<String> caseNos;

        public TestScript(File file, List<String> caseNos) {
            this.path = file.getAbsolutePath();
            this.lastModified = file.lastModified();
            this.caseNos = caseNos;
        }
    }
}

