/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.gui.app.sample;

import io.sitoolkit.util.buildtoolhelper.process.ProcessExitCallback;
import io.sitoolkit.wt.app.sample.SampleManager;
import io.sitoolkit.wt.gui.domain.sample.SampleProcessClient;
import io.sitoolkit.wt.gui.domain.sample.SampleStartedCallback;
import java.nio.file.Path;
import javax.annotation.Resource;

public class SampleService {
    SampleProcessClient client = new SampleProcessClient();
    @Resource
    SampleManager sampleManager;

    public void create(Path destDir) {
        Path sampledir = this.getSampleDir(destDir);
        if (!sampledir.toFile().exists()) {
            sampledir.toFile().mkdirs();
        }
        this.sampleManager.unarchiveBasicSample(destDir.toString());
    }

    public void start(int port, Path baseDir, SampleStartedCallback callback) {
        this.client.start(port, this.getSampleDir(baseDir), callback);
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(ProcessExitCallback callback) {
        this.client.stop(callback);
    }

    private Path getSampleDir(Path baseDir) {
        return baseDir.resolve("sample");
    }
}

