/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.testscript;

import io.sitoolkit.wt.domain.operation.Operation;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.ScreenshotTiming;
import io.sitoolkit.wt.infra.ELSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class TestStep {
    @Resource
    ELSupport el;
    private String no;
    private String itemName;
    private Operation operation;
    private String operationName;
    @Resource
    private Locator locator;
    private ScreenshotTiming screenshotTiming = ScreenshotTiming.NONE;
    private String dataType;
    private Map<String, String> testData = new HashMap<String, String>();
    private String currentCaseNo;
    private Set<String> dialogScreenshotCaseNoSet = new HashSet<String>();
    private String breakPoint;

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public String getValue() {
        String value = this.getTestData().get(this.getCurrentCaseNo());
        return this.el.evaluate(value);
    }

    public String[] getValues() {
        return StringUtils.isBlank(this.getValue()) ? new String[]{} : this.getValue().split("(:|;)");
    }

    public boolean getDialogValue() {
        String v = this.getValue().toLowerCase();
        return "true".equalsIgnoreCase(v) || "ok".equalsIgnoreCase(v) || "y".equalsIgnoreCase(v);
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Map<String, String> getTestData() {
        return this.testData;
    }

    public void setTestData(Map<String, String> testData) {
        this.testData = testData;
    }

    public void setTestData(String caseNo, String testData) {
        this.testData.put(caseNo, testData);
    }

    public ScreenshotTiming getScreenshotTiming() {
        return this.screenshotTiming;
    }

    public void setScreenshotTiming(String screenshotTiming) {
        this.screenshotTiming = ScreenshotTiming.getTiming(screenshotTiming);
    }

    public boolean beforeScreenshot() {
        return this.getScreenshotTiming().equals((Object)ScreenshotTiming.BEFORE) || this.getScreenshotTiming().equals((Object)ScreenshotTiming.AROUND);
    }

    public boolean afterScreenshot() {
        return this.getScreenshotTiming().equals((Object)ScreenshotTiming.AFTER) || this.getScreenshotTiming().equals((Object)ScreenshotTiming.AROUND);
    }

    public boolean dialogScreenshot() {
        return this.dialogScreenshotCaseNoSet.contains(this.getCurrentCaseNo());
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = StringUtils.lowerCase(dataType);
    }

    public boolean isSkip() {
        return StringUtils.isBlank(this.getValue());
    }

    public boolean isCaseStrExists() {
        return StringUtils.isNotBlank(this.getTestData().get(this.getCurrentCaseNo()));
    }

    public String getCurrentCaseNo() {
        return this.currentCaseNo;
    }

    public void setCurrentCaseNo(String currentCaseNo) {
        this.currentCaseNo = currentCaseNo;
    }

    public void addDialogScreenshotCaseNo(String caseNo) {
        this.dialogScreenshotCaseNoSet.add(caseNo);
    }

    public String getBreakPoint() {
        return this.breakPoint;
    }

    public void setBreakPoint(String breakPoint) {
        this.breakPoint = breakPoint;
    }

    public boolean isBreakPointEnabled() {
        return StringUtils.isNotEmpty(this.getBreakPoint());
    }
}

