/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.testscript;

import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TestScript {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    private String caseNoPrefix = "";
    private int caseNoColIndex;
    private List<TestStep> testStepList = new ArrayList<TestStep>();
    private List<String> headers = new ArrayList<String>();
    private Map<String, Integer> testStepNoMap = new HashMap<String, Integer>();
    private Map<String, Integer> caseNoMap = new HashMap<String, Integer>();
    private String name;
    private long lastModified;
    private File scriptFile;
    private String sheetName;

    public String getCaseNoPrefix() {
        if (this.caseNoPrefix == "") {
            this.setCaseNoPrefix();
        }
        return this.caseNoPrefix;
    }

    public void setCaseNoPrefix(String caseNoPrefix) {
        this.caseNoPrefix = caseNoPrefix;
    }

    private void setCaseNoPrefix() {
        this.caseNoPrefix = MessageManager.getMessage("testScript-header-caseNoPrefix");
    }

    public List<TestStep> getTestStepList() {
        return Collections.unmodifiableList(this.testStepList);
    }

    public void addTestStep(TestStep testStep) {
        if (testStep != null && testStep.getOperation() != null) {
            this.copyLocator(this.testStepList, testStep);
            this.testStepList.add(testStep);
            this.testStepNoMap.put(testStep.getNo(), this.testStepList.size() - 1);
        }
    }

    public List<String> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    public TestStep getTestStep(int index) {
        try {
            return this.testStepList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getTestStepCount() {
        return this.testStepList.size();
    }

    @Deprecated
    public Integer getScriptIndex(String testStepNo) {
        return this.testStepNoMap.get(testStepNo);
    }

    public void setTestStepList(List<TestStep> testStepList) {
        this.testStepList = testStepList;
    }

    public Map<String, Integer> getCaseNoMap() {
        return this.caseNoMap;
    }

    public void setCaseNoMap(Map<String, Integer> caseNoMap) {
        this.caseNoMap = caseNoMap;
    }

    public boolean containsCaseNo(String caseNo) {
        return this.caseNoMap.containsKey(caseNo);
    }

    public boolean isScriptFileChanged() {
        return this.lastModified != this.scriptFile.lastModified();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndexByScriptNo(String no) {
        Integer idx = this.testStepNoMap.get(no);
        return idx == null ? -1 : idx;
    }

    public String getSteptNo(int index) {
        TestStep testStep = this.getTestStep(index);
        return testStep == null ? null : testStep.getNo();
    }

    private void copyLocator(List<TestStep> list, TestStep testStep) {
        String itemName = testStep.getItemName();
        if (StringUtils.isBlank(itemName)) {
            return;
        }
        for (TestStep ts : list) {
            if (!itemName.equals(ts.getItemName()) || !testStep.getLocator().isEmpty()) continue;
            testStep.setLocator(ts.getLocator());
        }
    }

    public TestStep getLastStep() {
        return this.testStepList.get(this.testStepList.size() - 1);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getCaseNoColIndex() {
        return this.caseNoColIndex;
    }

    public void setCaseNoColIndex(int caseNoColIndex) {
        this.caseNoColIndex = caseNoColIndex;
    }
}

