/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.testscript;

import io.sitoolkit.wt.infra.resource.MessageManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ScreenshotTiming {
    NONE(""),
    BEFORE,
    AFTER,
    AROUND;

    private static Map<String, ScreenshotTiming> timingMap;
    private String label;

    private ScreenshotTiming(String label) {
        this.label = label;
    }

    private ScreenshotTiming() {
        this.label = MessageManager.getMessage("testScript-screenshot-" + this.name().toLowerCase());
    }

    public static ScreenshotTiming getTiming(String label) {
        return timingMap.get(StringUtils.defaultIfBlank(label, NONE.getLabel()));
    }

    public static List<String> getLabels() {
        return new ArrayList<String>(timingMap.keySet());
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    static {
        timingMap = new LinkedHashMap<String, ScreenshotTiming>();
        for (ScreenshotTiming timing : ScreenshotTiming.values()) {
            timingMap.put(timing.getLabel(), timing);
        }
    }
}

