/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.tester;

import io.sitoolkit.wt.domain.tester.TestContextListener;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestStep;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class TestContext {
    private TestScript testScript;
    private TestStep testStep;
    private String scriptName;
    private String caseNo;
    private String caseNoTmp;
    private TestScript testScriptTmp;
    private TestContextListener testContextListener;
    private int currentIndex;
    private int indexTmp;
    private Rectangle windowRect;
    private Map<String, Object> params = new HashMap<String, Object>();

    public boolean isContinued() {
        if (this.testContextListener == null) {
            return false;
        }
        this.testContextListener.onEnd(this);
        return true;
    }

    public void backup() {
        this.testScriptTmp = this.testScript;
        this.indexTmp = this.currentIndex;
        this.caseNoTmp = this.caseNo;
    }

    public void restore() {
        this.testScript = this.testScriptTmp;
        this.currentIndex = this.indexTmp + 1;
        this.testStep = this.testScript.getTestStep(this.currentIndex);
        this.caseNo = this.caseNoTmp;
    }

    public void reset() {
        this.currentIndex = 0;
        this.testStep = this.testScript.getTestStep(0);
    }

    public TestScript getTestScript() {
        return this.testScript;
    }

    public void setTestScript(TestScript testScript) {
        this.testScript = testScript;
    }

    public TestStep getTestStep() {
        return this.testStep;
    }

    public void setTestStep(TestStep testStep) {
        this.testStep = testStep;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getCaseNo() {
        return this.caseNo;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo;
    }

    public TestScript getTestScriptTmp() {
        return this.testScriptTmp;
    }

    public void setTestScriptTmp(TestScript testScriptTmp) {
        this.testScriptTmp = testScriptTmp;
    }

    public TestContextListener getTestContextListener() {
        return this.testContextListener;
    }

    public void setTestContextListener(TestContextListener testContextListener) {
        this.testContextListener = testContextListener;
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

    public <T> T getParam(String key) {
        return (T)this.params.get(key);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getTestStepNo() {
        return this.testStep == null ? "noTestStepNo" : this.testStep.getNo();
    }

    public String getItemName() {
        return this.testStep == null ? "noItemName" : this.testStep.getItemName();
    }

    public String getScreenshotTiming() {
        return this.testStep == null ? "noScreenshotTiming" : this.testStep.getScreenshotTiming().getLabel();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public Rectangle getWindowRect() {
        return this.windowRect;
    }

    public void setWindowRect(Rectangle windowRect) {
        this.windowRect = windowRect;
    }

    public void setWindowRect(int x, int y, int w, int h) {
        this.setWindowRect(new Rectangle(x, y, w, h));
    }

    public int getIndexTmp() {
        return this.indexTmp;
    }

    public void setIndexTmp(int indexTmp) {
        this.indexTmp = indexTmp;
    }
}

