/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.tester;

import io.sitoolkit.wt.app.config.RuntimeConfig;
import io.sitoolkit.wt.domain.testclass.TestClassNameConverter;
import io.sitoolkit.wt.domain.tester.TestEventListener;
import io.sitoolkit.wt.domain.tester.TestResult;
import io.sitoolkit.wt.domain.tester.Tester;
import io.sitoolkit.wt.infra.ApplicationContextHelper;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={RuntimeConfig.class})
public abstract class SitTesterTestBase {
    protected SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    @Rule
    public TestName testName = new TestName();
    protected Tester tester;

    protected String getCurrentCaseNo() {
        return TestClassNameConverter.method2caseNo(this.testName.getMethodName());
    }

    protected void test() {
        this.test(null);
    }

    protected void test(AfterTest afterTest) {
        this.test(this.getCurrentCaseNo(), afterTest);
    }

    protected void test(String caseNo, AfterTest afterTest) {
        TestResult result = this.tester.operate(caseNo);
        if (afterTest != null) {
            afterTest.callback();
        }
        if (!result.isSuccess()) {
            Assert.fail((String)result.buildReason());
        }
    }

    @Before
    public void setUp() {
        this.tester = ApplicationContextHelper.getBean(Tester.class);
        this.log.trace("setup", this, this.testName.getMethodName(), this.tester);
        this.tester.prepare(this.getTestScriptPath(), this.getSheetName(), this.getCurrentCaseNo());
        TestEventListener listener = ApplicationContextHelper.getBean(TestEventListener.class);
        listener.before();
    }

    @After
    public void tearDown() {
        TestEventListener listener = ApplicationContextHelper.getBean(TestEventListener.class);
        listener.after();
        this.tester.tearDown();
    }

    protected abstract String getTestScriptPath();

    protected abstract String getSheetName();

    protected static interface AfterTest {
        public void callback();
    }
}

