/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.pageload;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.pageload.ElementId;
import io.sitoolkit.wt.domain.testscript.TestStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PageContext {
    private String title;
    private String url;
    private SortedMap<ElementPosition, TestStep> map = new TreeMap<ElementPosition, TestStep>(new PointComparator());
    private Map<ElementId, List<TestStep>> formIdMap = new HashMap<ElementId, List<TestStep>>();

    public void add(ElementPosition pos, TestStep step, ElementId formId) {
        this.map.put(pos, step);
        if (formId != null) {
            List<TestStep> testSteps = this.formIdMap.get(formId);
            if (testSteps == null) {
                testSteps = new ArrayList<TestStep>();
                this.formIdMap.put(formId, testSteps);
            }
            testSteps.add(step);
        }
    }

    public List<TestStep> asList() {
        ArrayList<TestStep> list = new ArrayList<TestStep>();
        int stepNo = 1;
        for (Map.Entry<ElementPosition, TestStep> entry : this.map.entrySet()) {
            TestStep step = entry.getValue();
            step.setNo(Integer.toString(stepNo++));
            list.add(step);
        }
        return list;
    }

    public boolean containsNameInForm(ElementId formId, String name) {
        List<TestStep> testSteps = this.formIdMap.get(formId);
        if (testSteps == null) {
            return false;
        }
        for (TestStep testStep : testSteps) {
            if (!testStep.getLocator().equalsByName(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsName(String name) {
        for (Collection collection : this.formIdMap.values()) {
            for (TestStep testStep : collection) {
                if (testStep.getLocator() == null || !testStep.getLocator().equalsByName(name)) continue;
                return true;
            }
        }
        return false;
    }

    public TestStep create() {
        TestStep step = new TestStep();
        step.setCurrentCaseNo("001");
        step.setTestData("001", "y");
        return step;
    }

    public TestStep registTestStep(ElementPosition pos, ElementId formId) {
        TestStep step = this.create();
        this.add(pos, step, formId);
        return step;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private class PointComparator
    implements Comparator<ElementPosition> {
        private PointComparator() {
        }

        @Override
        public int compare(ElementPosition o1, ElementPosition o2) {
            if (o1 == null | o2 == null) {
                return 0;
            }
            int dy = o1.getY() - o2.getY();
            if (dy != 0) {
                return dy;
            }
            int dx = o1.getX() - o2.getX();
            if (dx != 0) {
                return dx;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }
}

