/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.util.ArrayList;
import org.openqa.selenium.NoSuchWindowException;
import org.springframework.stereotype.Component;

@Component
public class SwitchWindowOperation
extends SeleniumOperation {
    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        Locator windowLocator = testStep.getLocator();
        if (Locator.Type.title == windowLocator.getTypeVo()) {
            ArrayList<String> avairableName = new ArrayList<String>();
            ArrayList<String> avairableTitle = new ArrayList<String>();
            for (String windowHandle : this.seleniumDriver.getWindowHandles()) {
                String windowTitle = this.seleniumDriver.switchTo().window(windowHandle).getTitle();
                avairableName.add(windowHandle);
                avairableTitle.add(windowTitle);
                if (!windowTitle.equals(windowLocator.getValue())) continue;
                ctx.info("window.switch", windowLocator);
                return;
            }
            throw new NoSuchWindowException(MessageManager.getMessage("window.no.such.error", windowLocator, avairableName, avairableTitle));
        }
        ctx.info("window.switch", windowLocator);
        String windowName = windowLocator.getValue();
        if ("_parent".equalsIgnoreCase(windowName) || "null".equalsIgnoreCase(windowName)) {
            windowName = "";
        }
        this.seleniumDriver.switchTo().window(windowName);
    }
}

