/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import javax.annotation.Resource;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.springframework.stereotype.Component;

@Component
public class StoreElementValueOperation
extends SeleniumOperation {
    @Resource
    TestContext context;

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        Object value = null;
        String name = testStep.getValue();
        String[] type = testStep.getDataType().split(":");
        WebElement element = this.findElement(testStep.getLocator());
        switch (type[0]) {
            case "": 
            case "text": {
                value = element.getText();
                break;
            }
            case "tag": {
                value = element.getTagName();
                break;
            }
            case "attribute": {
                if (1 >= type.length) break;
                value = element.getAttribute(type[1]);
                break;
            }
            case "css": {
                if (1 >= type.length) break;
                value = element.getCssValue(type[1]);
                break;
            }
            case "location": {
                value = element.getLocation();
                break;
            }
            case "rect": {
                if (this.pm.isChromeDriver()) {
                    value = new Rectangle(element.getLocation(), element.getSize());
                    break;
                }
                value = element.getRect();
                break;
            }
            case "size": {
                value = element.getSize();
            }
        }
        if (value != null) {
            ctx.info(element, "var.define", name, value);
            this.context.addParam(name, value);
        }
    }
}

