/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import org.openqa.selenium.Dimension;
import org.springframework.stereotype.Component;

@Component
public class SetWindowSizeOperation
extends SeleniumOperation {
    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        String value = testStep.getValue();
        String[] size = value.split(",");
        if (size.length != 2) {
            this.log.warn("window.sizen.set.error");
            return;
        }
        try {
            int width = Integer.parseInt(size[0]);
            int height = Integer.parseInt(size[1]);
            ctx.info("window.size.set", width, height);
            Dimension targetSize = new Dimension(width, height);
            this.seleniumDriver.manage().window().setSize(targetSize);
        }
        catch (NumberFormatException e) {
            this.log.warn("window.sizen.set.error", e);
        }
    }
}

