/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.operation.ScreenshotOperation;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.infra.ConfigurationException;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
public class SeleniumScreenshotOperation
implements ScreenshotOperation {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(SeleniumScreenshotOperation.class);
    protected Robot robot;
    @Resource
    WebDriver seleniumDriver;
    @Resource
    TestContext current;
    @Resource
    PropertyManager pm;
    private int dialogWaitSpan = 500;

    public SeleniumScreenshotOperation() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            LOG.warn("warn", e);
        }
    }

    @Override
    public File get() {
        if (this.seleniumDriver instanceof TakesScreenshot) {
            if (this.pm.isResizeWindow()) {
                Dimension bodySize = this.seleniumDriver.findElement(By.tagName("body")).getSize();
                this.seleniumDriver.manage().window().setSize(bodySize);
                LOG.debug("body.size", bodySize);
            }
            try {
                return ((TakesScreenshot)((Object)this.seleniumDriver)).getScreenshotAs(OutputType.FILE);
            }
            catch (NoSuchWindowException nswe) {
                try {
                    File file = File.createTempFile("sit-wt", "screenshot-failure");
                    FileUtils.copyURLToFile(ResourceUtils.getURL("classpath:screenshot-failure.png"), file);
                    return file;
                }
                catch (IOException ioe) {
                    throw new ConfigurationException(ioe);
                }
                catch (Exception exp) {
                    throw new ConfigurationException(exp);
                }
            }
        }
        LOG.warn("driver.screenshot.error", this.seleniumDriver.getClass().getName());
        return null;
    }

    @Override
    public File getWithDialog() {
        if (this.robot == null) {
            return null;
        }
        Rectangle windowRect = this.current.getWindowRect();
        if (windowRect == null || windowRect.isEmpty()) {
            return null;
        }
        try {
            File file = File.createTempFile("sit-wt", "");
            try {
                Thread.sleep(this.getDialogWaitSpan());
            }
            catch (InterruptedException e) {
                LOG.warn("thread.sleep.error");
            }
            BufferedImage img = this.robot.createScreenCapture(windowRect);
            ImageIO.write((RenderedImage)img, "png", file);
            this.current.setWindowRect(null);
            return file;
        }
        catch (IOException e) {
            LOG.warn("screenshot.get.error", e);
            return null;
        }
    }

    public int getDialogWaitSpan() {
        return this.dialogWaitSpan;
    }

    public void setDialogWaitSpan(int dialogWaitSpan) {
        this.dialogWaitSpan = dialogWaitSpan;
    }
}

