/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.util.Arrays;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.springframework.stereotype.Component;

@Component
public class SelectOperation
extends SeleniumOperation {
    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        WebElement element = this.findElement(testStep.getLocator());
        ctx.info(element, MessagePattern.\u9805\u76ee\u306bXX\u3092YY\u3057\u307e\u3059, Arrays.toString(testStep.getValues()), MessageManager.getMessage("select"));
        Select select = new Select(element);
        StringBuilder sb = new StringBuilder();
        for (String value : testStep.getValues()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if ("index".equals(testStep.getDataType())) {
                sb.append(value + "\u756a\u76ee");
                select.selectByIndex(Integer.parseInt(value) - 1);
                continue;
            }
            if ("label".equals(testStep.getDataType())) {
                sb.append(value);
                if (this.pm.isEdgeDriver()) {
                    this.selectByVisibleTextForEdge(element, select, value);
                    continue;
                }
                select.selectByVisibleText(value);
                continue;
            }
            sb.append("\u5024=" + value);
            select.selectByValue(value);
        }
    }

    protected void selectByVisibleTextForEdge(WebElement element, Select select, String value) {
        boolean selected = false;
        for (WebElement option : select.getOptions()) {
            if (!value.equals(option.getText())) continue;
            ((JavascriptExecutor)((Object)this.seleniumDriver)).executeScript("arguments[0].selected = 'selected';", option);
            selected = true;
            ((JavascriptExecutor)((Object)this.seleniumDriver)).executeScript("if (typeof arguments[0].onchange == 'function') {arguments[0].onchange();}", element);
            break;
        }
        if (!selected) {
            throw new NoSuchElementException("Cannot locate element with text: " + value);
        }
    }
}

