/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.springframework.stereotype.Component;

@Component
public class InputOperation
extends SeleniumOperation {
    private static final String APPEND_PREFIX = "append:";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        String value = testStep.getValue();
        WebElement element = this.findElement(testStep.getLocator());
        if (this.hasAttribute(element, "type", "file")) {
            File file = new File(value);
            if (!file.exists()) throw new TestException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093 " + file.getAbsolutePath());
            ctx.info(element, MessagePattern.\u9805\u76ee\u306bXX\u3092YY\u3057\u307e\u3059, file.getAbsolutePath(), MessageManager.getMessage("input"));
            element.sendKeys(file.getAbsolutePath());
            return;
        } else {
            if (value.startsWith(APPEND_PREFIX)) {
                ctx.info(element, MessagePattern.\u9805\u76ee\u306bXX\u3092YY\u3057\u307e\u3059, value, MessageManager.getMessage("input.append"));
                value = StringUtils.substringAfter(value, APPEND_PREFIX);
            } else {
                ctx.info(element, MessagePattern.\u9805\u76ee\u306bXX\u3092YY\u3057\u307e\u3059, value, MessageManager.getMessage("input.overwite"));
                element.sendKeys(Keys.HOME, Keys.chord(Keys.SHIFT, Keys.END));
            }
            this.input(element, value);
        }
    }

    private boolean hasAttribute(WebElement element, String attr, String value) {
        try {
            return value.equals(element.getAttribute(attr));
        }
        catch (Exception e) {
            return false;
        }
    }
}

