/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation.selenium;

import io.sitoolkit.wt.domain.evidence.MessagePattern;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.TestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.springframework.stereotype.Component;

@Component
public class ChooseOperation
extends SeleniumOperation {
    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
        String[] values = testStep.getValues();
        ctx.info(MessagePattern.\u9805\u76ee\u306bXX\u3092YY\u3057\u307e\u3059, Arrays.asList(values), "\u9078\u629e");
        Map<String, Choice> map = this.toMap(values);
        List<WebElement> elements = null;
        elements = "label".equals(testStep.getDataType()) ? this.chooseByLabel(ctx, testStep.getLocator(), map) : this.chooseByValue(ctx, testStep.getLocator(), map);
        ctx.addOperatedElement(elements);
    }

    protected List<WebElement> chooseByLabel(SeleniumOperationContext ctx, Locator locator, Map<String, Choice> map) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement element : this.findElements(locator)) {
            String id = element.getAttribute("id");
            WebElement label = this.seleniumDriver.findElement(By.cssSelector("label[for='" + id + "']"));
            String labelText = StringUtils.trim(label.getText());
            Choice choice = map.get(labelText);
            if (choice == null || !this.setChecked(element, label, choice.on)) continue;
            elements.add(element);
        }
        return elements;
    }

    protected List<WebElement> chooseByValue(SeleniumOperationContext ctx, Locator locator, Map<String, Choice> map) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement element : this.findElements(locator)) {
            String value = element.getAttribute("value");
            Choice choice = map.get(value);
            if (choice == null || !this.setChecked(element, element, choice.on)) continue;
            elements.add(element);
        }
        return elements;
    }

    protected Map<String, Choice> toMap(String[] values) {
        HashMap<String, Choice> map = new HashMap<String, Choice>();
        for (String value : values) {
            Choice choice = new Choice();
            int idx = value.indexOf("_off");
            if (idx < 0) {
                choice.value = value;
                choice.on = true;
            } else {
                choice.value = value.substring(0, idx);
                choice.on = false;
            }
            map.put(choice.value, choice);
        }
        return map;
    }

    protected class Choice {
        protected String value;
        protected boolean on;

        protected Choice() {
        }
    }
}

