/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.operation;

import io.sitoolkit.wt.domain.evidence.LogRecord;
import io.sitoolkit.wt.domain.operation.Operation;
import io.sitoolkit.wt.domain.operation.OperationResult;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.TestException;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ExecOperation
implements Operation {
    protected SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    private static final String CMD_SEPARATOR = "[\\s]+";
    private static boolean OS_IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");

    @Override
    public OperationResult operate(TestStep testStep) {
        OperationResult result = new OperationResult();
        Object command = testStep.getLocator().getValue();
        if (OS_IS_WINDOWS) {
            command = "cmd /c " + (String)command;
        }
        result.addRecord(LogRecord.info(this.log, testStep, "cmd.execute", command));
        ProcessBuilder pb = new ProcessBuilder(((String)command).split(CMD_SEPARATOR));
        pb.redirectErrorStream(true);
        Process process = null;
        String cmdlog = null;
        InputStream is = null;
        int exitValue = 0;
        try {
            process = pb.start();
            process.waitFor();
            is = process.getInputStream();
            cmdlog = IOUtils.toString(is, Charset.defaultCharset());
            exitValue = process.exitValue();
        }
        catch (Exception e) {
            try {
                throw new TestException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        if (process != null) {
            process.destroy();
        }
        if (!StringUtils.isEmpty(cmdlog)) {
            result.addRecord(LogRecord.info(this.log, testStep, "cmd.result", cmdlog));
        }
        if (exitValue != 0) {
            throw new TestException(MessageManager.getMessage("cmd.exception") + (String)command);
        }
        return result;
    }
}

