/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.httpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import io.sitoolkit.wt.infra.resource.MessageManager;
import io.sitoolkit.wt.infra.template.TemplateEngine;
import io.sitoolkit.wt.infra.template.TemplateModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class SitHttpHandler
implements HttpHandler {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(SitHttpHandler.class);
    @Resource
    private TemplateEngine templateEngine;
    private String baseDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            String requestUrl = StringUtils.substringBefore(httpExchange.getRequestURI().toString(), "?");
            Path requestPath = Paths.get(this.baseDir, requestUrl);
            this.setContentType(httpExchange, requestUrl);
            httpExchange.getResponseHeaders().add("connection", "close");
            byte[] response = "POST".equals(httpExchange.getRequestMethod()) ? this.createResponseMessage(requestPath, this.readPostParams(httpExchange)) : this.createResponseMessage(requestPath);
            httpExchange.sendResponseHeaders(200, response.length);
            httpExchange.getResponseBody().write(response);
        }
        catch (FileNotFoundException fe) {
            LOG.warn("httpserver.filenotfound", fe);
            httpExchange.getResponseHeaders().add("connection", "close");
            httpExchange.sendResponseHeaders(404, 0L);
        }
        catch (Exception e) {
            LOG.warn("httpserver.internalerror", e);
            httpExchange.getResponseHeaders().add("connection", "close");
            httpExchange.sendResponseHeaders(503, 0L);
        }
        finally {
            httpExchange.getResponseBody().close();
        }
    }

    private void setContentType(HttpExchange httpExchange, String requestUrl) {
        Headers header = httpExchange.getResponseHeaders();
        switch (StringUtils.substringAfterLast(requestUrl, ".")) {
            case "pdf": {
                header.add("content-type", "application/pdf");
                break;
            }
            case "css": {
                header.add("content-type", "text/css");
                break;
            }
            default: {
                header.add("content-type", "text/html; charset=utf-8");
            }
        }
    }

    private byte[] createResponseMessage(Path requestPath) throws IOException {
        return this.createResponseMessage(requestPath, null);
    }

    private byte[] createResponseMessage(Path requestPath, Map<String, String> postParams) throws IOException {
        if (Files.exists(requestPath, new LinkOption[0])) {
            return FileUtils.readFileToByteArray(requestPath.toFile());
        }
        if (Files.exists(Paths.get(StringUtils.replace(requestPath.toString(), "html", "vm"), new String[0]), new LinkOption[0])) {
            return this.readVelocityTemplate(StringUtils.replace(requestPath.getFileName().toString(), "html", "vm"), postParams);
        }
        if ("favicon.ico".equals(requestPath.getFileName().toString())) {
            return new byte[0];
        }
        throw new FileNotFoundException(requestPath.toString() + " is not exists");
    }

    private byte[] readVelocityTemplate(String templatePath, Map<String, String> postParams) throws UnsupportedEncodingException {
        TemplateModel model = new TemplateModel();
        model.setTemplate("/webapp/" + templatePath);
        HashMap<String, String> vmProperties = new HashMap<String, String>(MessageManager.getResourceAsMap());
        if (Objects.nonNull(postParams)) {
            postParams.forEach((k, v) -> vmProperties.put((String)k, (String)v));
        }
        model.setProperties(vmProperties);
        return this.templateEngine.writeToString(model).getBytes("UTF-8");
    }

    private Map<String, String> readPostParams(final HttpExchange httpExchange) throws FileUploadException {
        ServletFileUpload up = new ServletFileUpload(new DiskFileItemFactory());
        List<FileItem> result = up.parseRequest(new RequestContext(){

            @Override
            public String getCharacterEncoding() {
                return "UTF-8";
            }

            @Override
            public int getContentLength() {
                return 0;
            }

            @Override
            public String getContentType() {
                return httpExchange.getRequestHeaders().getFirst("Content-type");
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return httpExchange.getRequestBody();
            }
        });
        return result.stream().collect(Collectors.toMap(FileItem::getFieldName, fi -> {
            String string;
            block8: {
                InputStream is = fi.getInputStream();
                try {
                    string = IOUtils.toString(is, "UTF-8");
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
                is.close();
            }
            return string;
        }));
    }

    @Generated
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }
}

