/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.httpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.io.IOException;
import lombok.Generated;

public class ShutdownRequestHandler
implements HttpHandler {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(ShutdownRequestHandler.class);
    private boolean requested = false;

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            byte[] httpResponse = "Shutdown Request Received.".getBytes("UTF-8");
            httpExchange.getResponseHeaders().add("connection", "close");
            httpExchange.sendResponseHeaders(200, httpResponse.length);
            httpExchange.getResponseBody().write(httpResponse);
            this.requested = true;
        }
        catch (Exception e) {
            LOG.warn("httpserver.internalerror", e);
            httpExchange.getResponseHeaders().add("connection", "close");
            httpExchange.sendResponseHeaders(503, 0L);
        }
        finally {
            httpExchange.getResponseBody().close();
        }
    }

    @Generated
    public boolean isRequested() {
        return this.requested;
    }
}

