/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence.selenium;

import io.sitoolkit.wt.domain.evidence.DialogScreenshotSupport;
import io.sitoolkit.wt.domain.operation.selenium.DialogOperation;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class SeleniumDialogScreenshotSupport
implements DialogScreenshotSupport {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    private Set<String> windowSizeCheckNoSet = new HashSet<String>();
    @Resource
    WebDriver seleniumDriver;
    @Resource
    TestContext current;

    @Override
    public void checkReserve(List<TestStep> testSteps, String caseNo) {
        block0: for (int i = testSteps.size() - 1; i >= 0; --i) {
            TestStep testStep = testSteps.get(i);
            testStep.setCurrentCaseNo(caseNo);
            if (!testStep.isCaseStrExists() || !(testStep.getOperation() instanceof DialogOperation) || !testStep.beforeScreenshot()) continue;
            int reservedIdx = i;
            while (reservedIdx > 0) {
                TestStep reservedScript = testSteps.get(reservedIdx);
                reservedScript.setCurrentCaseNo(caseNo);
                if (!reservedScript.isCaseStrExists() || --reservedIdx != i - 2) continue;
                this.windowSizeCheckNoSet.add(reservedScript.getNo());
                testStep.addDialogScreenshotCaseNo(caseNo);
                continue block0;
            }
        }
        this.log.debug("window.size.check", this.windowSizeCheckNoSet);
    }

    @Override
    public void reserveWindowRect(String testStepNo) {
        if (this.windowSizeCheckNoSet.contains(testStepNo)) {
            this.log.debug("window.get");
            Point winPos = this.seleniumDriver.manage().window().getPosition();
            Dimension winSize = this.seleniumDriver.manage().window().getSize();
            this.current.setWindowRect(winPos.getX(), winPos.getY(), winSize.getWidth(), winSize.getHeight());
        }
    }
}

