/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence.selenium;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import javax.annotation.Resource;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ElementPositionSupport {
    protected final SitLogger log = SitLoggerFactory.getLogger(this.getClass());
    @Resource
    protected WebDriver driver;
    private WebElement currentFrame;

    public WebElement getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(WebElement currentFrame) {
        this.currentFrame = currentFrame;
    }

    protected Point getCurrentBasePosition() {
        if (this.currentFrame == null) {
            return this.driver.findElement(By.tagName("html")).getLocation();
        }
        this.driver.switchTo().defaultContent();
        Point documentPos = this.driver.findElement(By.tagName("html")).getLocation();
        Point framePos = this.currentFrame.getLocation();
        this.driver.switchTo().frame(this.currentFrame);
        return new Point(documentPos.getX() - framePos.getX(), documentPos.getY() - framePos.getY());
    }

    public ElementPosition get(WebElement element) {
        if (element == null) {
            return ElementPosition.EMPTY;
        }
        if (this.driver instanceof TakesScreenshot) {
            Point elementPos = element.getLocation();
            Point basePos = this.getCurrentBasePosition();
            this.log.debug("element.position", element, elementPos, basePos);
            return new ElementPosition(elementPos.getX() - basePos.getX(), elementPos.getY() - basePos.getY(), element.getSize().getWidth(), element.getSize().getHeight());
        }
        return ElementPosition.EMPTY;
    }
}

