/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence.appium;

import io.appium.java_client.AppiumDriver;
import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.selenium.ElementPositionSupport;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class HybridElementPositionSupport
extends ElementPositionSupport {
    private Point basePos;
    private double scale;
    private boolean initialized;

    @Override
    public ElementPosition get(WebElement element) {
        if (!this.initialized) {
            AppiumDriver appiumDriver = (AppiumDriver)this.driver;
            String context = appiumDriver.getContext();
            appiumDriver.context("NATIVE_APP");
            WebElement baseElement = appiumDriver.findElementByClassName("android.webkit.WebView");
            this.basePos = baseElement.getLocation();
            Dimension dim = baseElement.getSize();
            appiumDriver.context(context);
            WebElement htmlElement = appiumDriver.findElementByTagName("body");
            this.scale = (double)dim.getWidth() / (double)htmlElement.getSize().getWidth();
            this.initialized = true;
            this.log.debug("\u5ea7\u6a19\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f \u57fa\u6e96\u5ea7\u6a19:{}, \u7e2e\u5c3a:{}", this.basePos, this.scale);
        }
        Point elementPos = element.getLocation();
        this.log.debug("\u8981\u7d20:{}, \u8981\u7d20\u4f4d\u7f6e:{}", element, elementPos);
        return new ElementPosition((double)elementPos.getX() * this.scale + (double)this.basePos.getX(), (double)elementPos.getY() * this.scale + (double)this.basePos.getY(), (double)element.getSize().getWidth() * this.scale, (double)element.getSize().getHeight() * this.scale);
    }
}

