/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.ScreenshotTiming;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;

public class Screenshot {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(Screenshot.class);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private File file;
    private String filePath;
    private int screenshotPaddingWidth;
    private int screenshotPaddingHeight;
    private int width;
    private boolean resize;
    private boolean resizing;
    private List<ElementPosition> positions = new ArrayList<ElementPosition>();
    private ScreenshotTiming timing;
    private String errorMesage;

    public void addElementPosition(ElementPosition pos) {
        this.positions.add(pos);
    }

    public void clearElementPosition() {
        this.positions.clear();
    }

    public Future<?> resize() {
        if (this.file == null) {
            return null;
        }
        if (this.positions.isEmpty()) {
            return null;
        }
        if (!this.resize) {
            return EXECUTOR.submit(() -> {
                try {
                    this.width = ImageIO.read(this.file).getWidth();
                }
                catch (IOException e) {
                    LOG.warn("warn", e);
                }
            });
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        for (ElementPosition pos : this.positions) {
            minX = Math.min(minX, pos.getX());
            minY = Math.min(minY, pos.getY());
            maxX = Math.max(maxX, pos.getX() + pos.getW());
            maxY = Math.max(maxY, pos.getY() + pos.getH());
        }
        LOG.debug("element.info", this.positions.size(), maxX, minY, maxX, maxY);
        this.resizing = true;
        return EXECUTOR.submit(new Resizer(minX, minY, maxX, maxY));
    }

    public String getFileName() {
        return this.file == null ? "" : this.file.getName();
    }

    public List<ElementPosition> getPositions() {
        return this.positions;
    }

    public void setPositions(List<ElementPosition> positions) {
        this.positions = positions;
    }

    public void setResize(boolean resize) {
        this.resize = resize;
    }

    public boolean isResize() {
        return this.resize;
    }

    public void setScreenshotPaddingWidth(int screenshotPaddingWidth) {
        this.screenshotPaddingWidth = screenshotPaddingWidth;
    }

    public void setScreenshotPaddingHeight(int screenshotPaddingHeight) {
        this.screenshotPaddingHeight = screenshotPaddingHeight;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public ScreenshotTiming getTiming() {
        return this.timing;
    }

    public void setTiming(ScreenshotTiming timing) {
        this.timing = timing;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public synchronized boolean isResizing() {
        return this.resizing;
    }

    public String getErrorMesage() {
        return this.errorMesage;
    }

    public void setErrorMesage(String errorMesage) {
        this.errorMesage = errorMesage;
    }

    public int getWidth() {
        return this.width;
    }

    private class Resizer
    implements Runnable {
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        public Resizer(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BufferedImage orgImg = ImageIO.read(Screenshot.this.file);
                int subX = Math.max(this.minX - Screenshot.this.screenshotPaddingWidth, 0);
                int subY = Math.max(this.minY - Screenshot.this.screenshotPaddingHeight, 0);
                int subW = Math.min(this.maxX - this.minX + Screenshot.this.screenshotPaddingWidth * 2, orgImg.getWidth() - subX);
                int subH = Math.min(this.maxY - this.minY + Screenshot.this.screenshotPaddingHeight * 2, orgImg.getHeight() - subY);
                for (ElementPosition pos : Screenshot.this.positions) {
                    pos.setX(pos.getX() - subX);
                    pos.setY(pos.getY() - subY);
                }
                BufferedImage subImg = orgImg.getSubimage(subX, subY, subW, subH);
                Screenshot.this.width = subImg.getWidth();
                ImageIO.write((RenderedImage)subImg, "png", Screenshot.this.file);
                LOG.debug("origonal.image.info", orgImg.getWidth(), orgImg.getHeight(), subX, subY, subW, subH, Screenshot.this.file.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("screenshot.resize.error", Screenshot.this.file.getName(), e);
            }
            finally {
                Screenshot.this.resizing = false;
            }
        }
    }
}

