/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence;

import io.sitoolkit.wt.domain.evidence.ElementPosition;
import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class MaskInfo {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(MaskInfo.class);
    private static String USER_HOME = System.getProperty("user.home");
    private static String DOWNLOAD_FOLDER = "Downloads";
    private static String baseEvidence = System.getProperty("evidence.base");
    private Map<String, List<ElementPosition>> maskInfoAsMap = new HashMap<String, List<ElementPosition>>();

    private MaskInfo() {
    }

    public static MaskInfo load(EvidenceDir targetDir) {
        MaskInfo maskInfo = new MaskInfo();
        HashMap<String, List<ElementPosition>> evdenceMaskInfo = new HashMap<String, List<ElementPosition>>();
        EvidenceDir baseDir = EvidenceDir.baseEvidenceDir(baseEvidence, targetDir.getBrowser());
        for (File evidenceFile : targetDir.getEvidenceFiles()) {
            String maskFileName = evidenceFile.getName() + ".json";
            String maskFilePathInBase = FilenameUtils.concat(baseDir.getDir().getPath(), "mask");
            File maskFileInBase = new File(maskFilePathInBase, maskFileName);
            String dlPath = StringUtils.join((Object[])new String[]{USER_HOME, DOWNLOAD_FOLDER}, "/");
            File maskFileInDl = new File(dlPath, maskFileName);
            String jsonString = null;
            try {
                if (maskFileInBase.exists()) {
                    jsonString = FileUtils.readFileToString(maskFileInBase, "UTF-8");
                } else {
                    if (!maskFileInDl.exists()) continue;
                    jsonString = FileUtils.readFileToString(maskFileInDl, "UTF-8");
                    FileUtils.moveFileToDirectory(maskFileInDl, new File(maskFilePathInBase), true);
                }
                MaskInfo.convertToMap(evdenceMaskInfo, jsonString);
            }
            catch (IOException e) {
                LOG.info("mask.load.error", e);
            }
        }
        maskInfo.setMaskInfoAsMap(evdenceMaskInfo);
        return maskInfo;
    }

    private static void convertToMap(Map<String, List<ElementPosition>> evidenceMaskInfo, String jsonString) {
        JsonReader reader = Json.createReader(new StringReader(jsonString));
        JsonObject jsonObj = reader.readObject();
        reader.close();
        JsonArray jsonArray = jsonObj.getJsonArray("maskInfo");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject obj = jsonArray.getJsonObject(i);
            JsonArray posStyles = obj.getJsonArray("posStyle");
            if (posStyles.isEmpty()) continue;
            String imgSrc = FilenameUtils.getName(obj.getString("imgSrc"));
            ArrayList<ElementPosition> positions = new ArrayList<ElementPosition>();
            for (int j = 0; j < posStyles.size(); ++j) {
                JsonObject obj2 = posStyles.getJsonObject(j);
                double posX = obj2.getInt("x");
                double posY = obj2.getInt("y");
                double width = obj2.getInt("width");
                double height = obj2.getInt("height");
                ElementPosition pos = new ElementPosition(posX, posY, width, height);
                positions.add(pos);
            }
            evidenceMaskInfo.put(imgSrc, positions);
        }
    }

    public Map<String, List<ElementPosition>> getMaskInfoAsMap() {
        return this.maskInfoAsMap;
    }

    public void setMaskInfoAsMap(Map<String, List<ElementPosition>> maskInfoAsMap) {
        this.maskInfoAsMap = maskInfoAsMap;
    }
}

