/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence;

import io.sitoolkit.wt.domain.evidence.EvidenceDir;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class EvidenceOpener {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(EvidenceOpener.class);
    private int openFileCount = 1;
    private String evidenceFileRegex = ".*\\.html$";
    private String maskFileRegex = "^mask_.*html$";
    private String compareFileRegex = "^comp_(?!mask_|ng_).*html$";
    private String compareNgFileRegex = "^comp_ng_.*html$";

    public void open() {
        this.openFiles(null, this.evidenceFileRegex, "");
    }

    public void openCompareEvidence(EvidenceDir targetDir) {
        this.openFiles(targetDir, this.compareFileRegex, "\u6bd4\u8f03");
    }

    public void openCompareNgEvidence(EvidenceDir targetDir) {
        this.openFiles(targetDir, this.compareNgFileRegex, "\u6bd4\u8f03NG");
    }

    public void openMaskEvidence(EvidenceDir targetDir) {
        this.openFiles(targetDir, this.maskFileRegex, "\u30de\u30b9\u30af");
    }

    public void openFiles(EvidenceDir targetDir, String targetFileRegex, String evidenceType) {
        File evidenceDir;
        File file = evidenceDir = targetDir == null ? EvidenceDir.getLatestEvidenceDir() : targetDir.getDir();
        if (evidenceDir == null) {
            return;
        }
        ArrayList<File> targetFiles = new ArrayList<File>(FileUtils.listFiles(evidenceDir, new RegexFileFilter(targetFileRegex), TrueFileFilter.INSTANCE));
        LOG.info("evidence.info", evidenceDir.getName(), targetFiles.size(), evidenceType);
        Collections.sort(targetFiles, new FileLastModifiedComarator(true));
        try {
            int openFiles = 0;
            for (File file2 : targetFiles) {
                Desktop.getDesktop().open(file2);
                if (++openFiles < this.openFileCount) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void openTarget(File targetFile) {
        this.evidenceFileRegex = targetFile.getName() + ".*\\.html$";
        this.open();
    }

    public static void main(String[] args) {
        EvidenceOpener opener = new EvidenceOpener();
        opener.open();
    }

    public class FileLastModifiedComarator
    implements Comparator<File> {
        private int signum = 1;

        public FileLastModifiedComarator() {
        }

        public FileLastModifiedComarator(boolean ascending) {
            this();
            this.signum = ascending ? 1 : -1;
        }

        @Override
        public int compare(File o1, File o2) {
            return this.signum * (int)(o1.lastModified() - o2.lastModified());
        }
    }
}

