/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.evidence;

import io.sitoolkit.wt.infra.PropertyUtils;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;

public class EvidenceDir {
    private static final SitLogger LOG = SitLoggerFactory.getLogger(EvidenceDir.class);
    private static final String BASE_EVIDENCE_ROOT = "base-evidence";
    private static final String COMPARE_PREFIX = "comp_";
    private static final String COMPARE_NG_PREFIX = "comp_ng_";
    private static final String MASK_PREFIX = "mask_";
    private static final String UNMATCH_PREFIX = "unmatch_";
    private static final String FAILSAFE_REPORT_NAME = "failsafe-report.html";
    private static final String REPORT_DIR = "report";
    private static final String IMG_BASE_DIR = "base";
    private static final String EVIDENCE_ROOT_DIR = "evidence";
    private File dir;
    private static String evidenceDirRegex = "^evidence_.*";

    private EvidenceDir() {
    }

    public static EvidenceDir getInstance(File dir) {
        EvidenceDir instance = new EvidenceDir();
        instance.dir = dir;
        return instance;
    }

    public static EvidenceDir getInstance(String dir) {
        return EvidenceDir.getInstance(new File(dir));
    }

    public static EvidenceDir getBase(String browser) {
        return EvidenceDir.getInstance(new File(EvidenceDir.getProjectDirectory(), "base-evidence/" + browser));
    }

    public static String getRoot() {
        return EVIDENCE_ROOT_DIR;
    }

    public static EvidenceDir getLatest() {
        return EvidenceDir.getInstance(EvidenceDir.getLatestEvidenceDir());
    }

    public static File getLatestEvidenceDir() {
        File outputDir = new File(EvidenceDir.getProjectDirectory() + "/evidence");
        if (!outputDir.exists()) {
            LOG.info("evidence.dirs.empty", outputDir.getAbsolutePath());
            return null;
        }
        ArrayList<File> evidenceDirs = new ArrayList<File>(FileUtils.listFilesAndDirs(outputDir, FalseFileFilter.INSTANCE, new RegexFileFilter(evidenceDirRegex)));
        evidenceDirs.remove(outputDir);
        Collections.sort(evidenceDirs, new FileNameComarator(false));
        if (evidenceDirs.isEmpty()) {
            LOG.info("evidence.dirs.empty", outputDir.getAbsolutePath());
            return null;
        }
        return (File)evidenceDirs.get(0);
    }

    public static EvidenceDir targetEvidenceDir(String dir) {
        return dir == null ? EvidenceDir.getLatest() : EvidenceDir.getInstance(dir);
    }

    public static EvidenceDir baseEvidenceDir(String dir, String browser) {
        return dir == null ? EvidenceDir.getBase(browser) : EvidenceDir.getInstance(dir);
    }

    private static String getProjectDirectory() {
        String dir = System.getProperty("sitwt.projectDirectory");
        return StringUtils.isEmpty(dir) ? "." : dir;
    }

    public List<File> getEvidenceFiles() {
        return FileUtils.listFiles(this.dir, new String[]{"html"}, true).stream().filter(this::isNormalEvidenceFile).collect(Collectors.toList());
    }

    private boolean isNormalEvidenceFile(File file) {
        String htmlName = file.getName();
        return !this.isReport(file.toPath()) && !EvidenceDir.isCompareEvidence(htmlName) && !EvidenceDir.isCompareNgEvidence(htmlName) && !EvidenceDir.isMaskEvidence(htmlName);
    }

    public Collection<File> getScreenshots(String evidenceFileName) {
        return this.getScreenshotFilesAsMap(evidenceFileName).values();
    }

    public Map<String, File> getScreenshotFilesAsMap(String evidenceFileName) {
        HashMap<String, File> screenshotFiles = new HashMap<String, File>();
        String evidenceName = StringUtils.removeEnd(evidenceFileName, ".html");
        for (File imgFile : FileUtils.listFiles(this.dir, new String[]{"png"}, true)) {
            String imgName = imgFile.getName();
            if (!EvidenceDir.isEvidenceScreenshot(imgName, evidenceName) && !EvidenceDir.isMaskEvidenceScreenshot(imgName, evidenceName) && !EvidenceDir.isUnmatchEvidenceScreenshot(imgName, evidenceName) && !EvidenceDir.isUnmatchMaskEvidenceScreenshot(imgName, evidenceName)) continue;
            screenshotFiles.put(imgFile.getName(), imgFile);
        }
        return screenshotFiles;
    }

    public static String extractTable(File evidenceFile) throws IOException {
        List<String> lines = FileUtils.readLines(evidenceFile, "UTF-8");
        int tableTagStart = lines.indexOf("    <table class=\"table\">");
        int tableTagEnd = lines.indexOf("    </table>");
        if (tableTagStart == -1 || tableTagEnd == -1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines.subList(tableTagStart, tableTagEnd + 1)) {
            sb.append(StringUtils.join("        ", line, "\n"));
        }
        return sb.toString();
    }

    public static String removeInputLine(String htmlString) throws IOException {
        String[] lines = htmlString.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (line.trim().startsWith("<input")) continue;
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    public static String replaceImgPath(String str) {
        return StringUtils.replace(str, "src=\"img", "src=\"img/base");
    }

    public static String toMaskEvidenceName(String name) {
        return EvidenceDir.concat(MASK_PREFIX, name);
    }

    public static String toCompareMaskEvidenceName(String name) {
        return EvidenceDir.concat("comp_mask_", name);
    }

    public static String toMaskSsName(String name) {
        return EvidenceDir.concat(MASK_PREFIX, name);
    }

    public static String toUnmatchSsName(String name) {
        return EvidenceDir.concat(UNMATCH_PREFIX, name);
    }

    public static String toUnmatchMaskSsName(String name) {
        return EvidenceDir.concat("unmatch_mask_", name);
    }

    private static String concat(String prefix, String str) {
        return prefix + str;
    }

    public static String toBeforeMaskSsName(String name) {
        return StringUtils.removeStart(name, MASK_PREFIX);
    }

    public static boolean isBaseImgDir(File file) {
        return file.isDirectory() && IMG_BASE_DIR.equals(file.getName());
    }

    public static boolean existsReport(String resourcePath) {
        return new File(resourcePath, FAILSAFE_REPORT_NAME).exists();
    }

    public static String getCompareEvidencePrefix(boolean withUnmatch) {
        return withUnmatch ? COMPARE_NG_PREFIX : COMPARE_PREFIX;
    }

    public static boolean isCompareEvidence(String name) {
        return EvidenceDir.startsWith(name, COMPARE_PREFIX);
    }

    public static boolean isCompareNgEvidence(String name) {
        return EvidenceDir.startsWith(name, COMPARE_NG_PREFIX);
    }

    public static boolean isMaskEvidence(String name) {
        return EvidenceDir.startsWith(name, MASK_PREFIX);
    }

    public static boolean isEvidenceScreenshot(String ssName, String evidenceName) {
        return EvidenceDir.startsWith(ssName, evidenceName);
    }

    public static boolean isMaskEvidenceScreenshot(String name, String evidenceName) {
        return EvidenceDir.startsWith(name, MASK_PREFIX + evidenceName);
    }

    public static boolean isUnmatchEvidenceScreenshot(String ssName, String evidenceName) {
        return EvidenceDir.startsWith(ssName, UNMATCH_PREFIX + evidenceName);
    }

    public static boolean isUnmatchMaskEvidenceScreenshot(String ssName, String evidenceName) {
        return EvidenceDir.startsWith(ssName, "unmatch_mask_" + evidenceName);
    }

    public static boolean isMaskScreenshot(String name) {
        return EvidenceDir.startsWith(name, MASK_PREFIX);
    }

    public static boolean isUnmatchScreenshot(String name) {
        return EvidenceDir.startsWith(name, UNMATCH_PREFIX);
    }

    public static boolean isUnmatchMaskScreenshot(String name) {
        return EvidenceDir.startsWith(name, "unmatch_mask_");
    }

    private static boolean startsWith(String name, String prefix) {
        return StringUtils.startsWith(name, prefix);
    }

    public boolean exists() {
        return this.dir != null && this.dir.exists();
    }

    public String getBrowser() {
        Properties prop = PropertyUtils.loadFromPathWithCache(new File(this.dir, "sit-wt.properties").getAbsolutePath());
        return prop.getProperty("driverType");
    }

    public File getDir() {
        return this.dir;
    }

    public Path getReportDir() {
        return this.dir.toPath().resolve(REPORT_DIR);
    }

    public boolean isReport(Path path) {
        return path.toAbsolutePath().normalize().startsWith(this.getReportDir().toAbsolutePath().normalize());
    }

    public Path getFailsafeReport() {
        return this.getReportDir().resolve(FAILSAFE_REPORT_NAME);
    }

    public File getImgBaseDir() {
        return new File(StringUtils.join((Object[])new String[]{this.dir.getPath(), "img", IMG_BASE_DIR}, "/"));
    }

    public Path getMaskEvidence(String name) {
        return this.getEvidenceWithPrefix(MASK_PREFIX, name);
    }

    public Path getCompareEvidence(String name) {
        return this.getEvidenceWithPrefix(COMPARE_PREFIX, name);
    }

    public Path getCompareMaskEvidence(String name) {
        return this.getEvidenceWithPrefix("comp_mask_", name);
    }

    public Path getCompareNgEvidence(String name) {
        return this.getEvidenceWithPrefix(COMPARE_NG_PREFIX, name);
    }

    private Path getEvidenceWithPrefix(String prefix, String name) {
        return this.dir.toPath().resolve(prefix + name);
    }

    public static class FileNameComarator
    implements Comparator<File> {
        private int signum = 1;

        public FileNameComarator() {
        }

        public FileNameComarator(boolean ascending) {
            this();
            this.signum = ascending ? 1 : -1;
        }

        @Override
        public int compare(File o1, File o2) {
            return this.signum * o1.compareTo(o2);
        }
    }
}

