/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.debug.selenium;

import io.sitoolkit.wt.domain.debug.LocatorChecker;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperation;
import io.sitoolkit.wt.domain.operation.selenium.SeleniumOperationContext;
import io.sitoolkit.wt.domain.testscript.Locator;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.PropertyManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.WebElement;

public class SeleniumLocatorChecker
extends SeleniumOperation
implements LocatorChecker {
    @Resource
    PropertyManager pm;

    @Override
    public void execute(TestStep testStep, SeleniumOperationContext ctx) {
    }

    @Override
    public void check(Locator locator) {
        try {
            this.seleniumDriver.manage().timeouts().implicitlyWait(0L, TimeUnit.MICROSECONDS);
            List<WebElement> elements = this.seleniumDriver.findElements(this.by(locator));
            this.seleniumDriver.manage().timeouts().implicitlyWait(this.pm.getImplicitlyWait(), TimeUnit.MILLISECONDS);
            if (elements.isEmpty()) {
                this.log.info("element.not.found", locator);
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (WebElement element : elements) {
                sb.append("\n    ");
                sb.append("<");
                sb.append(element.getTagName());
                sb.append(this.getAttribute(element, "id"));
                sb.append(this.getAttribute(element, "type"));
                sb.append(this.getAttribute(element, "name"));
                sb.append(this.getAttribute(element, "class"));
                sb.append(this.getAttribute(element, "href"));
                sb.append(this.getAttribute(element, "src"));
                sb.append(this.getAttribute(element, "value"));
                sb.append("...");
            }
            this.log.info("element.found", locator, sb);
        }
        catch (InvalidSelectorException e) {
            this.log.info("locator.error", locator, e.getLocalizedMessage());
        }
    }

    private String getAttribute(WebElement element, String attr) {
        String attrVal = element.getAttribute(attr);
        if (StringUtils.isEmpty(attrVal)) {
            return "";
        }
        return " " + attr + "=\"" + attrVal + "\"";
    }
}

