/*
 * Decompiled with CFR 0.152.
 */
package io.sitoolkit.wt.domain.debug;

import io.sitoolkit.wt.domain.debug.CommandKey;
import io.sitoolkit.wt.domain.debug.DebugCommand;
import io.sitoolkit.wt.domain.debug.DebugListener;
import io.sitoolkit.wt.domain.tester.TestContext;
import io.sitoolkit.wt.domain.testscript.TestScript;
import io.sitoolkit.wt.domain.testscript.TestScriptDao;
import io.sitoolkit.wt.domain.testscript.TestStep;
import io.sitoolkit.wt.infra.PropertyManager;
import io.sitoolkit.wt.infra.log.SitLogger;
import io.sitoolkit.wt.infra.log.SitLoggerFactory;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public class DebugSupport {
    private static SitLogger LOG = SitLoggerFactory.getLogger(DebugSupport.class);
    private static final String USAGE_DESC = CommandKey.buildUsage();
    @Resource
    TestContext current;
    @Resource
    TestScriptDao dao;
    @Resource
    ApplicationContext appCtx;
    @Resource
    PropertyManager pm;
    Optional<DebugListener> listener = Optional.empty();
    private int pauseSpan = 800;
    private ExecutorService executor;
    private DebugCommand cmd;
    private boolean paused = false;

    public boolean next() {
        int currentIndex = this.current.getCurrentIndex();
        int nextIndex = currentIndex + 1;
        TestScript testScript = this.current.getTestScript();
        LOG.debug("debug.test", this.current);
        if (currentIndex < testScript.getTestStepCount()) {
            if (this.pm.isDebug()) {
                LOG.debug("debug.index", currentIndex, testScript.getTestStepCount());
                TestStep nextStep = testScript.getTestStep(nextIndex);
                if (nextStep != null && nextStep.isBreakPointEnabled()) {
                    LOG.info("debug.break.point");
                    this.pause();
                }
                nextIndex = this.getNextIndex(currentIndex);
            }
            if (nextIndex >= testScript.getTestStepCount()) {
                this.sendCaseEnd();
                return this.current.isContinued();
            }
            this.current.setCurrentIndex(nextIndex);
            this.current.setTestStep(this.current.getTestScript().getTestStep(nextIndex));
            this.sendStepStart();
            return true;
        }
        this.sendCaseEnd();
        return this.current.isContinued();
    }

    protected int getNextIndex(int currentIndex) {
        if (!this.isPaused()) {
            return currentIndex + 1;
        }
        int ret = currentIndex;
        while (this.isPaused()) {
            this.sendStepPausing(ret + 1);
            try {
                Thread.sleep(this.getPauseSpan());
            }
            catch (InterruptedException e) {
                LOG.warn("thread.sleep.error", e);
            }
            TestScript testScript = this.current.getTestScript();
            if (testScript.isScriptFileChanged()) {
                LOG.info("script.file.changed");
                this.current.setTestScript(this.dao.load(testScript.getScriptFile(), testScript.getSheetName(), false));
            }
            if (this.cmd == null || this.cmd.key == null) continue;
            int cmdRet = this.cmd.execute(ret, this.current.getTestScript(), this.appCtx);
            if (cmdRet < 0) {
                LOG.info("cmd.error");
            } else {
                ret = cmdRet;
                if (this.current.getTestScript().getTestStep(ret) == null) {
                    LOG.info("test.step.end");
                    break;
                }
                LOG.info("empty");
                LOG.info("test.step.next.prev");
                for (int i = ret - 1; i <= ret + 1; ++i) {
                    TestStep nextStep = this.current.getTestScript().getTestStep(i);
                    if (nextStep == null) continue;
                    String nextMark = i == ret + 1 ? " <- \u6b21\u306b\u5b9f\u884c" : "";
                    LOG.info("test.step.next", nextStep.getNo(), nextStep.getItemName(), nextStep.getLocator(), nextMark);
                }
                LOG.info("empty");
            }
            if (this.cmd.key.release && cmdRet >= 0) {
                this.cmd = null;
                break;
            }
            this.cmd = null;
        }
        return ret;
    }

    @PostConstruct
    public void init() {
        if (!this.pm.isDebug()) {
            return;
        }
        LOG.info("debug.execute");
        if (this.pm.isCli()) {
            LOG.info("enter.pause.click");
        }
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try (Scanner scan = new Scanner(System.in);){
                    while ((DebugSupport.this.cmd = DebugCommand.readLine(scan.nextLine())) != null) {
                        if (DebugSupport.this.cmd.key == CommandKey.START) {
                            LOG.info("test.restart");
                            DebugSupport.this.setPaused(false);
                            continue;
                        }
                        if (DebugSupport.this.cmd != DebugCommand.NA) continue;
                        if (!DebugSupport.this.isPaused()) {
                            DebugSupport.this.pause();
                            continue;
                        }
                        DebugSupport.this.showUsage();
                    }
                }
            }
        });
    }

    public void restart(String stepNo) {
        LOG.info("test.restart");
        this.cmd = StringUtils.isEmpty(stepNo) ? new DebugCommand(CommandKey.START, "") : new DebugCommand(CommandKey.EXEC_STEP_NO, stepNo);
        this.setPaused(false);
    }

    public void forward() {
        if (!this.isPaused()) {
            return;
        }
        this.cmd = new DebugCommand(CommandKey.FORWARD, "");
    }

    public void back() {
        if (!this.isPaused()) {
            return;
        }
        this.cmd = new DebugCommand(CommandKey.BACK, "");
    }

    public void checkLocator(String locatorStr) {
        this.cmd = new DebugCommand(CommandKey.LOC, locatorStr);
    }

    public void export() {
        this.cmd = new DebugCommand(CommandKey.EXPORT, "");
    }

    public void pause() {
        LOG.info("test.pause");
        if (this.pm.isCli()) {
            LOG.info("enter.click");
        }
        this.setPaused(true);
    }

    public void exit() {
        this.cmd = new DebugCommand(CommandKey.EXIT, "");
    }

    private void showUsage() {
        if (this.pm.isCli()) {
            LOG.info("show.usage", USAGE_DESC);
        }
    }

    @PreDestroy
    public void destroy() {
        this.sendClose();
        if (this.pm.isDebug()) {
            this.executor.shutdownNow();
        }
    }

    public int getPauseSpan() {
        return this.pauseSpan;
    }

    public synchronized void setPauseSpan(int pauseSpan) {
        this.pauseSpan = pauseSpan;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setListener(DebugListener listener) {
        this.listener = Optional.ofNullable(listener);
    }

    public void start() {
        this.sendStepStart();
    }

    private void sendStepPausing(int nextStepIndex) {
        this.listener.ifPresent(l -> {
            Path path = this.current.getTestScript().getScriptFile().toPath();
            int caseIndex = this.current.getTestScript().getCaseNoMap().get(this.current.getCaseNo());
            l.onDebugging(path, nextStepIndex, caseIndex);
        });
    }

    private void sendStepStart() {
        this.listener.ifPresent(l -> {
            Path path = this.current.getTestScript().getScriptFile().toPath();
            int caseIndex = this.current.getTestScript().getCaseNoMap().get(this.current.getCaseNo());
            int stepIndex = this.current.getCurrentIndex();
            l.onDebugging(path, stepIndex, caseIndex);
        });
    }

    private void sendCaseEnd() {
        this.listener.ifPresent(l -> {
            Path path = this.current.getTestScript().getScriptFile().toPath();
            int caseIndex = this.current.getTestScript().getCaseNoMap().get(this.current.getCaseNo());
            l.onCaseEnd(path, caseIndex);
        });
    }

    private void sendClose() {
        this.listener.ifPresent(l -> l.onClose());
    }
}

